/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.findusages.impl;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.ElementUtils;
import org.netbeans.modules.groovy.refactoring.findusages.impl.AbstractFindUsagesVisitor;

public class FindTypeUsagesVisitor
extends AbstractFindUsagesVisitor {
    private final String findingFqn;

    public FindTypeUsagesVisitor(ModuleNode moduleNode, String findingFqn) {
        super(moduleNode);
        this.findingFqn = ElementUtils.normalizeTypeName((String)findingFqn, null);
    }

    public void visitArrayExpression(ArrayExpression expression) {
        this.addIfEquals((ASTNode)expression);
        super.visitArrayExpression(expression);
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.addIfEquals((ASTNode)expression);
        super.visitDeclarationExpression(expression);
    }

    public void visitClassExpression(ClassExpression expression) {
        this.addIfEquals((ASTNode)expression);
        super.visitClassExpression(expression);
    }

    public void visitField(FieldNode field) {
        this.addIfEquals((ASTNode)field);
        super.visitField(field);
    }

    public void visitProperty(PropertyNode property) {
        if (property.isSynthetic()) {
            this.addIfEquals((ASTNode)property);
        }
        super.visitProperty(property);
    }

    public void visitImports(ModuleNode node) {
        for (ImportNode importNode : node.getImports()) {
            ClassNode importType = importNode.getType();
            if (importNode.isStar()) continue;
            importNode.setLineNumber(importType.getLineNumber());
            importNode.setColumnNumber(importType.getColumnNumber());
            importNode.setLastLineNumber(importType.getLastLineNumber());
            importNode.setLastColumnNumber(importType.getLastColumnNumber());
            if (!this.isEquals((ASTNode)importNode)) continue;
            this.usages.add(new ASTUtils.FakeASTNode((ASTNode)importNode, importNode.getClassName()));
        }
        super.visitImports(node);
    }

    public void visitClass(ClassNode clazz) {
        if (this.isEquals((ASTNode)clazz.getSuperClass())) {
            this.usages.add(new ASTUtils.FakeASTNode((ASTNode)clazz.getUnresolvedSuperClass(false), clazz.getSuperClass().getNameWithoutPackage()));
        }
        for (ClassNode interfaceNode : clazz.getInterfaces()) {
            this.addIfEquals((ASTNode)interfaceNode);
        }
        super.visitClass(clazz);
    }

    protected void visitConstructorOrMethod(MethodNode method, boolean isConstructor) {
        if (!isConstructor && this.isEquals((ASTNode)method.getReturnType())) {
            this.addIfEquals((ASTNode)method);
        }
        for (Parameter param : method.getParameters()) {
            this.addIfEquals((ASTNode)param);
        }
        super.visitConstructorOrMethod(method, isConstructor);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.addIfEquals((ASTNode)call);
        super.visitConstructorCallExpression(call);
    }

    public void visitForLoop(ForStatement forLoop) {
        this.addIfEquals((ASTNode)forLoop);
        super.visitForLoop(forLoop);
    }

    private void addIfEquals(ASTNode node) {
        GenericsType[] genericTypes;
        ClassNode type = ElementUtils.getType((ASTNode)node);
        if (this.isEquals(node)) {
            if (type.getLineNumber() > 0 && type.getColumnNumber() > 0) {
                this.usages.add(new ASTUtils.FakeASTNode((ASTNode)type, ElementUtils.getTypeName((ASTNode)node)));
            } else if (node.getLineNumber() > 0 && node.getColumnNumber() > 0) {
                this.usages.add(new ASTUtils.FakeASTNode(node, ElementUtils.getTypeName((ASTNode)node)));
            }
        }
        if ((genericTypes = type.getGenericsTypes()) != null && genericTypes.length > 0) {
            for (GenericsType genericType : genericTypes) {
                this.addIfEquals((ASTNode)genericType.getType());
            }
        }
    }

    private boolean isEquals(ASTNode node) {
        return this.findingFqn.equals(ElementUtils.getTypeName((ASTNode)node));
    }
}

