/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.ProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CheckoutCompleted {
    private final File workingFolder;
    private String[] checkedOutFolders;

    public CheckoutCompleted(File workingFolder, String[] checkedOutFolders) {
        this.checkedOutFolders = checkedOutFolders;
        this.workingFolder = workingFolder;
    }

    public void scanForProjects(SvnProgressSupport support, Type type) {
        HashMap checkedOutProjects = new HashMap();
        checkedOutProjects.put(null, new HashSet());
        File normalizedWorkingFolder = FileUtil.normalizeFile((File)this.workingFolder);
        SvnUtils.refreshParents(normalizedWorkingFolder);
        FileObject fo = FileUtil.toFileObject((File)normalizedWorkingFolder);
        if (fo != null) {
            for (int i = 0; i < this.checkedOutFolders.length; ++i) {
                if (support != null && support.isCanceled()) {
                    return;
                }
                String module = this.checkedOutFolders[i];
                if (".".equals(module)) {
                    ProjectUtilities.scanForProjects((FileObject)fo, checkedOutProjects);
                    break;
                }
                FileObject subfolder = fo.getFileObject(module);
                if (subfolder == null) continue;
                ProjectUtilities.scanForProjects((FileObject)subfolder, checkedOutProjects);
            }
        }
        switch (type) {
            case EXPORT: {
                ProjectUtilities.openExportedProjects(checkedOutProjects, (File)this.workingFolder);
                break;
            }
            case CHECKOUT: {
                ProjectUtilities.openCheckedOutProjects(checkedOutProjects, (File)this.workingFolder);
            }
        }
    }

    public static enum Type {
        EXPORT,
        CHECKOUT;

    }
}

