/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.diff.DiffNode;
import org.netbeans.modules.subversion.ui.diff.MultiDiffPanel;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.ui.status.OpenInEditorAction;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.SortedTable;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.MouseUtils;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

class DiffFileTable
implements MouseListener,
ListSelectionListener,
AncestorListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private DiffNode[] nodes = new DiffNode[0];
    private EditorCookie[] editorCookies;
    private String[] tableColumns;
    private TableSorter sorter;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Node.Property p1 = (Node.Property)o1;
            Node.Property p2 = (Node.Property)o2;
            String sk1 = (String)p1.getValue("sortkey");
            if (sk1 != null) {
                String sk2 = (String)p2.getValue("sortkey");
                return sk1.compareToIgnoreCase(sk2);
            }
            try {
                String s1 = (String)p1.getValue();
                String s2 = (String)p2.getValue();
                return s1.compareToIgnoreCase(s2);
            }
            catch (Exception e) {
                Subversion.LOG.log(Level.SEVERE, null, e);
                return 0;
            }
        }
    };
    private final MultiDiffPanel master;
    private PropertyChangeListener changeListener;

    public DiffFileTable(MultiDiffPanel master) {
        ResourceBundle loc = NbBundle.getBundle(DiffFileTable.class);
        columnLabels.put("name", new String[]{loc.getString("CTL_DiffTable_Column_Name_Title"), loc.getString("CTL_DiffTable_Column_Name_Desc")});
        columnLabels.put("property", new String[]{loc.getString("CTL_DiffTable_Column_Property_Title"), loc.getString("CTL_DiffTable_Column_Property_Desc")});
        columnLabels.put("status", new String[]{loc.getString("CTL_DiffTable_Column_Status_Title"), loc.getString("CTL_DiffTable_Column_Status_Desc")});
        columnLabels.put("location", new String[]{loc.getString("CTL_DiffTable_Column_Location_Title"), loc.getString("CTL_DiffTable_Column_Location_Desc")});
        this.master = master;
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new SortedTable(this.sorter);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setSelectionMode(2);
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color borderColor = UIManager.getColor("scrollpane_border");
        if (borderColor == null) {
            borderColor = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new DiffTableCellRenderer());
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffFileTable.class, (String)"ACSN_DiffTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffFileTable.class, (String)"ACSD_DiffTable"));
        this.setColumns(new String[]{"name", "property", "status", "location"});
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.table.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffFileTable.this.showPopup(Utils.getPositionForPopup((JTable)DiffFileTable.this.table));
            }
        });
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block5: {
                    int width;
                    block4: {
                        width = DiffFileTable.this.table.getWidth();
                        if (DiffFileTable.this.tableColumns.length != 3) break block4;
                        for (int i = 0; i < DiffFileTable.this.tableColumns.length; ++i) {
                            if ("location".equals(DiffFileTable.this.tableColumns[i])) {
                                DiffFileTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 60 / 100);
                                continue;
                            }
                            DiffFileTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 20 / 100);
                        }
                        break block5;
                    }
                    if (DiffFileTable.this.tableColumns.length != 4) break block5;
                    for (int i = 0; i < DiffFileTable.this.tableColumns.length; ++i) {
                        if ("location".equals(DiffFileTable.this.tableColumns[i])) {
                            DiffFileTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 55 / 100);
                            continue;
                        }
                        DiffFileTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 15 / 100);
                    }
                }
            }
        });
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] columns) {
        if (Arrays.equals(columns, this.tableColumns)) {
            return;
        }
        this.setModelProperties(columns);
        this.tableColumns = columns;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
        this.setDefaultColumnSizes();
    }

    private void setModelProperties(String[] columns) {
        Node.Property[] properties = new Node.Property[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String[] labels = columnLabels.get(column);
            properties[i] = new ColumnDescriptor(column, labels[0], labels[1]);
        }
        this.tableModel.setProperties(properties);
    }

    void setTableModel(Setup[] setups, EditorCookie[] editorCookies) {
        this.editorCookies = editorCookies;
        this.nodes = DiffFileTable.setupsToNodes(setups);
        this.tableModel.setNodes((Node[])this.nodes);
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object source = e.getSource();
                String propertyName = e.getPropertyName();
                if ("modified".equals(propertyName) && source instanceof EditorCookie.Observable) {
                    DiffFileTable.this.statusModifiedChanged((EditorCookie)((EditorCookie.Observable)source));
                }
            }
        };
        for (EditorCookie editorCookie : this.editorCookies) {
            if (!(editorCookie instanceof EditorCookie.Observable)) continue;
            ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.changeListener, (Object)editorCookie));
        }
    }

    private void statusModifiedChanged(EditorCookie editorCookie) {
        int index = CollectionUtils.findInArray((Object[])this.editorCookies, (Object)editorCookie);
        if (index == -1) {
            return;
        }
        this.tableModel.fireTableChanged((TableModelEvent)new TableSorter.SortingSafeTableModelEvent((TableModel)this.tableModel, index, 0));
    }

    private static DiffNode[] setupsToNodes(Setup[] setups) {
        DiffNode[] nodes = new DiffNode[setups.length];
        for (int i = 0; i < setups.length; ++i) {
            nodes[i] = setups[i].getNode();
        }
        return nodes;
    }

    void focus() {
        this.table.requestFocus();
    }

    void setSelectedIndex(int currentIndex) {
        if (currentIndex == this.table.getSelectedRow()) {
            return;
        }
        this.table.getSelectionModel().setSelectionInterval(currentIndex, currentIndex);
        this.table.scrollRectToVisible(this.table.getCellRect(currentIndex, 0, true));
    }

    public int getSelectedIndex() {
        return this.table.getSelectedRow();
    }

    public int getSelectedModelIndex() {
        return this.getModelIndex(this.table.getSelectedRow());
    }

    public int getModelIndex(int viewIndex) {
        return viewIndex != -1 ? this.sorter.modelIndex(viewIndex) : -1;
    }

    public JTable getTable() {
        return this.table;
    }

    private void showPopup(final MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.table.getSelectedRows();
            for (int i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPopupMenu menu;
                if (DiffFileTable.this.table.isShowing() && (menu = DiffFileTable.this.master.getPopup()) != null) {
                    menu.show(DiffFileTable.this.table, e.getX(), e.getY());
                }
            }
        });
    }

    private void showPopup(Point p) {
        JPopupMenu menu = this.master.getPopup();
        if (menu != null) {
            menu.show(this.table, p.x, p.y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e)) {
            int row = this.table.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            Action action = this.nodes[row = this.sorter.modelIndex(row)].getPreferredAction();
            if (action == null || !action.isEnabled()) {
                action = new OpenInEditorAction();
            }
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        if (min != -1 && min == max) {
            this.master.tableRowSelected(this.table.getSelectedRow());
        } else {
            ArrayList<DiffNode> selectedNodes = new ArrayList<DiffNode>();
            if (min == -1) {
                this.master.tableRowSelected(-1);
            } else {
                for (int i = min; i <= max; ++i) {
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    int idx = this.sorter.modelIndex(i);
                    selectedNodes.add(this.nodes[idx]);
                }
            }
            TopComponent tc = (TopComponent)this.master.getClientProperty(TopComponent.class);
            if (tc == null) {
                return;
            }
            Node[] nodesToActivate = selectedNodes.toArray(new Node[0]);
            tc.setActivatedNodes(nodesToActivate);
        }
    }

    private class DiffTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private DiffTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            if (modelColumnIndex == 0) {
                int modelRow = DiffFileTable.this.sorter.modelIndex(row);
                String htmlDisplayName = DiffUtils.getHtmlDisplayName((Node)DiffFileTable.this.nodes[modelRow], (boolean)this.isModified(modelRow), (boolean)isSelected);
                if (SvnModuleConfig.getDefault().isExcludedFromCommit(DiffFileTable.this.nodes[modelRow].getSetup().getBaseFile().getAbsolutePath())) {
                    htmlDisplayName = "<s>" + (htmlDisplayName == null ? DiffFileTable.this.nodes[modelRow].getName() : htmlDisplayName) + "</s>";
                }
                if (htmlDisplayName != null) {
                    value = "<html>" + htmlDisplayName;
                }
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                File file = (File)DiffFileTable.this.nodes[DiffFileTable.this.sorter.modelIndex(row)].getLookup().lookup(File.class);
                String path = file != null ? file.getAbsolutePath() : null;
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }

        private boolean isModified(int row) {
            EditorCookie editorCookie = DiffFileTable.this.editorCookies[row];
            return editorCookie != null ? editorCookie.isModified() : false;
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly<String> {
        public ColumnDescriptor(String name, String displayName, String shortDescription) {
            super(name, String.class, displayName, shortDescription);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

