/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.print;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.modules.extexecution.input.LineParsingHelper;
import org.openide.windows.OutputWriter;

public final class InputProcessors {
    private static final Logger LOGGER = Logger.getLogger(InputProcessors.class.getName());

    private InputProcessors() {
    }

    @NonNull
    public static InputProcessor printing(@NonNull OutputWriter out, boolean resetEnabled) {
        return InputProcessors.printing(out, null, resetEnabled);
    }

    @NonNull
    public static InputProcessor printing(@NonNull OutputWriter out, @NullAllowed LineConvertor convertor, boolean resetEnabled) {
        return new PrintingInputProcessor(out, convertor, resetEnabled);
    }

    private static class PrintingInputProcessor
    implements InputProcessor {
        private final OutputWriter out;
        private final LineConvertor convertor;
        private final boolean resetEnabled;
        private final LineParsingHelper helper = new LineParsingHelper();
        private boolean closed;

        public PrintingInputProcessor(OutputWriter out, LineConvertor convertor, boolean resetEnabled) {
            assert (out != null);
            this.out = out;
            this.convertor = convertor;
            this.resetEnabled = resetEnabled;
        }

        public void processInput(char[] chars) {
            String[] lines;
            assert (chars != null);
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            for (String line : lines = this.helper.parse(chars)) {
                LOGGER.log(Level.FINEST, "{0}\\n", line);
                this.convert(line);
                this.out.flush();
            }
            String line = this.helper.getTrailingLine(true);
            if (line != null) {
                LOGGER.log(Level.FINEST, line);
                this.out.print(line);
                this.out.flush();
            }
        }

        public void reset() throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            if (!this.resetEnabled) {
                return;
            }
            this.out.reset();
        }

        public void close() throws IOException {
            this.closed = true;
            this.out.close();
        }

        private void convert(String line) {
            if (this.convertor == null) {
                this.out.println(line);
                return;
            }
            List<ConvertedLine> convertedLines = this.convertor.convert(line);
            if (convertedLines == null) {
                this.out.println(line);
                return;
            }
            for (ConvertedLine converted : convertedLines) {
                if (converted.getListener() == null) {
                    this.out.println(converted.getText());
                    continue;
                }
                try {
                    this.out.println(converted.getText(), converted.getListener());
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    this.out.println(converted.getText());
                }
            }
        }
    }
}

