/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.payara.jakartaee.Hk2LibraryProvider;
import org.netbeans.modules.payara.jakartaee.JavaEEServerModule;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.spi.PayaraModuleFactory;
import org.netbeans.modules.payara.spi.ServerUtilities;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JavaEEServerModuleFactory
implements PayaraModuleFactory {
    private static final Logger LOGGER = Logger.getLogger("payara-jakartaee");
    private static final JavaEEServerModuleFactory singleton = new JavaEEServerModuleFactory();
    private static final RequestProcessor RP = new RequestProcessor("JavaEEServerModuleFactory");
    private static final String CLASS_LIBRARY_TYPE = "j2se";
    private static final String CLASSPATH_VOLUME = "classpath";
    private static final String JAVADOC_VOLUME = "javadoc";
    private static final String ECLIPSE_LINK_LIB = "EclipseLink-GlassFish-v";
    private static final String EL_CORE_JAR_MATCHER = "eclipselink-wrapper(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String PERSISTENCE_API_JAR_MATCHER_1 = "javax.javaee(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String PERSISTENCE_API_JAR_MATCHER_2 = "javax.persistence(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String PERSISTENCE_JAVADOC = "javaee-doc-api.jar";
    private static final String[] PAYARA_LIBRARIES = new String[]{"web-core", "payara-api"};
    private static final String JAVA_EE_LIB = "Java-EE-Payara-v";
    private static final String JAVA_EE_JAVADOC = "javaee-doc-api.jar";

    private JavaEEServerModuleFactory() {
    }

    public static PayaraModuleFactory getDefault() {
        return singleton;
    }

    public boolean isModuleSupported(String payaraHome, Properties asenvProps) {
        File jar = ServerUtilities.getJarName((String)payaraHome, (String)"glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (jar == null) {
            return false;
        }
        return jar.exists();
    }

    public Object createModule(Lookup instanceLookup) {
        InstanceProperties ip = null;
        final PayaraModule commonModule = (PayaraModule)instanceLookup.lookup(PayaraModule.class);
        if (commonModule != null) {
            Map props = commonModule.getInstanceProperties();
            String url = (String)props.get("url");
            ip = InstanceProperties.getInstanceProperties((String)url);
            if (ip == null) {
                block6: {
                    String username = (String)props.get("username");
                    String password = null;
                    String displayName = (String)props.get("displayName");
                    try {
                        ip = InstanceProperties.createInstancePropertiesNonPersistent((String)url, (String)username, password, (String)displayName, (Map)props);
                    }
                    catch (InstanceCreationException ex) {
                        ip = InstanceProperties.getInstanceProperties((String)url);
                        if (null != ip) break block6;
                        LOGGER.log(Level.WARNING, null, ex);
                    }
                }
                if (ip == null) {
                    LOGGER.log(Level.INFO, "Unable to create/locate J2EE InstanceProperties for {0}", url);
                }
            }
            RP.post(new Runnable(){

                @Override
                public void run() {
                    JavaEEServerModuleFactory.ensureEclipseLinkSupport(commonModule.getInstance());
                    JavaEEServerModuleFactory.ensurePayaraApiSupport(commonModule.getInstance());
                }
            });
        } else {
            LOGGER.log(Level.WARNING, "commonModule is NULL");
        }
        return ip != null ? new JavaEEServerModule(instanceLookup, ip) : null;
    }

    private static boolean ensureEclipseLinkSupport(PayaraServer server) {
        String payaraHome = server.getServerHome();
        ArrayList<URL> libraryList = new ArrayList<URL>();
        ArrayList<URL> docList = new ArrayList<URL>();
        try {
            File f = ServerUtilities.getJarName((String)payaraHome, (String)EL_CORE_JAR_MATCHER);
            if (f != null && f.exists()) {
                libraryList.add(ServerUtilities.fileToUrl((File)f));
            } else {
                for (File candidate : new File(payaraHome, "modules").listFiles()) {
                    if (candidate.getName().indexOf("org.eclipse.persistence") == -1) continue;
                    libraryList.add(ServerUtilities.fileToUrl((File)candidate));
                }
            }
            f = ServerUtilities.getJarName((String)payaraHome, (String)PERSISTENCE_API_JAR_MATCHER_1);
            if (f != null && f.exists()) {
                libraryList.add(ServerUtilities.fileToUrl((File)f));
            } else {
                f = ServerUtilities.getJarName((String)payaraHome, (String)PERSISTENCE_API_JAR_MATCHER_2);
                if (f != null && f.exists()) {
                    libraryList.add(ServerUtilities.fileToUrl((File)f));
                }
            }
            File j2eeDoc = InstalledFileLocator.getDefault().locate("docs/javaee-doc-api.jar", "org.netbeans.modules.j2ee.platform", false);
            if (j2eeDoc != null) {
                docList.add(ServerUtilities.fileToUrl((File)j2eeDoc));
            } else {
                LOGGER.log(Level.WARNING, "Warning: Java EE documentation not found when registering EclipseLink library.");
            }
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            return false;
        }
        return JavaEEServerModuleFactory.addLibrary(ECLIPSE_LINK_LIB + server.getPlatformVersion().getMajor(), libraryList, docList, NbBundle.getMessage(JavaEEServerModuleFactory.class, (String)"DNAME_PF_ECLIPSELINK", (Object)server.getPlatformVersion().getMajor()), NbBundle.getMessage(JavaEEServerModuleFactory.class, (String)"DESC_PF_ECLIPSELINK"));
    }

    private static boolean ensurePayaraApiSupport(PayaraServer server) {
        String payaraHome = server.getServerHome();
        Hk2LibraryProvider provider = Hk2LibraryProvider.getProvider(server);
        ArrayList<URL> libraryList = new ArrayList<URL>();
        libraryList.addAll(provider.getJavaEEClassPathURLs());
        libraryList.addAll(provider.getMicroProfileClassPathURLs());
        libraryList.addAll(provider.getJerseyClassPathURLs());
        ArrayList<URL> docList = new ArrayList<URL>();
        File j2eeDoc = InstalledFileLocator.getDefault().locate("docs/javaee-doc-api.jar", "org.netbeans.modules.j2ee.platform", false);
        if (j2eeDoc != null) {
            try {
                docList.add(ServerUtilities.fileToUrl((File)j2eeDoc));
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.INFO, "Problem while registering Java EE API library JavaDoc.");
            }
        } else {
            LOGGER.log(Level.INFO, "Java EE documentation not found when registering Java EE API library.");
        }
        for (String entry : PAYARA_LIBRARIES) {
            File f = ServerUtilities.getJarName((String)payaraHome, (String)(entry + "(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar"));
            if (f == null || !f.exists()) continue;
            try {
                libraryList.add(ServerUtilities.fileToUrl((File)f));
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.INFO, "Problem while registering web-core into Payara API library.");
            }
        }
        return JavaEEServerModuleFactory.addLibrary(JAVA_EE_LIB + server.getPlatformVersion().getMajor(), libraryList, docList, NbBundle.getMessage(JavaEEServerModuleFactory.class, (String)"DNAME_PF_JAVA_EE_IMPL", (Object)server.getPlatformVersion().getMajor()), NbBundle.getMessage(JavaEEServerModuleFactory.class, (String)"DESC_PF_JAVA_EE_IMPL"));
    }

    private static boolean addLibrary(String name, List<URL> libraryList, List<URL> docList, String displayName, String description) {
        return JavaEEServerModuleFactory.addLibrary(name, CLASS_LIBRARY_TYPE, libraryList, docList, displayName, description);
    }

    private static synchronized boolean addLibrary(String name, String libType, List<URL> libraryList, List<URL> docList, String displayName, String description) {
        Library lib;
        block27: {
            String libPath;
            List libList;
            LibraryManager lmgr = LibraryManager.getDefault();
            int size = 0;
            lib = lmgr.getLibrary(name);
            if (lib != null) {
                libList = lib.getContent(CLASSPATH_VOLUME);
                size = libList.size();
                for (URL libUrl : libList) {
                    libPath = libUrl.getFile();
                    if (libPath.length() > 5) {
                        libPath = libPath.substring(5);
                    }
                    if (new File(libPath.replace("!/", "")).exists()) continue;
                    LOGGER.log(Level.FINE, "libPath does not exist.  Updating {0}", name);
                    try {
                        lmgr.removeLibrary(lib);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                    lib = null;
                    size = 0;
                    break;
                }
            }
            if (lib != null && size < libraryList.size()) {
                try {
                    lmgr.removeLibrary(lib);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
                lib = null;
            }
            if (lib != null) {
                libList = lib.getContent(JAVADOC_VOLUME);
                size = libList.size();
                for (URL libUrl : libList) {
                    libPath = libUrl.getFile();
                    if (libPath.length() > 5) {
                        libPath = libPath.substring(5);
                    }
                    if (new File(libPath.replace("!/", "")).exists()) continue;
                    LOGGER.log(Level.FINE, "libPath does not exist.  Updating {0}", name);
                    try {
                        lmgr.removeLibrary(lib);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    lib = null;
                    size = 0;
                    break;
                }
            }
            if (lib != null && null != docList && size < docList.size()) {
                try {
                    lmgr.removeLibrary(lib);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
                lib = null;
            }
            if (lib == null) {
                try {
                    LibraryTypeProvider ltp;
                    HashMap<String, List<URL>> contents = new HashMap<String, List<URL>>();
                    if (null != libraryList) {
                        contents.put(CLASSPATH_VOLUME, libraryList);
                    }
                    if (null != docList) {
                        contents.put(JAVADOC_VOLUME, docList);
                    }
                    if (null != (ltp = LibrariesSupport.getLibraryTypeProvider((String)libType))) {
                        lib = lmgr.createLibrary(libType, name, displayName, description, contents);
                        LOGGER.log(Level.FINE, "Created library {0}", name);
                    } else {
                        lmgr.addPropertyChangeListener((PropertyChangeListener)new InitializeLibrary(lmgr, libType, name, contents, displayName, description));
                        LOGGER.log(Level.FINE, "schedule to create library {0}", name);
                    }
                }
                catch (IOException | IllegalArgumentException ex) {
                    lib = lmgr.getLibrary(name);
                    if (lib != null) break block27;
                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        }
        return lib != null;
    }

    static class InitializeLibrary
    implements PropertyChangeListener {
        private final LibraryManager lmgr;
        private String name;
        private Map<String, List<URL>> content;
        private final String libType;
        private final String displayName;
        private final String description;

        InitializeLibrary(LibraryManager lmgr, String libType, String name, Map<String, List<URL>> content, String displayName, String description) {
            this.lmgr = lmgr;
            this.name = name;
            this.content = content;
            this.libType = libType;
            this.displayName = displayName;
            this.description = description;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JavaEEServerModuleFactory javaEEServerModuleFactory = singleton;
            synchronized (javaEEServerModuleFactory) {
                if (null != this.name) {
                    Library l = this.lmgr.getLibrary(this.name);
                    InitializeLibrary pcl = this;
                    if (null == l) {
                        try {
                            LibraryTypeProvider ltp = LibrariesSupport.getLibraryTypeProvider((String)this.libType);
                            if (null != ltp) {
                                this.lmgr.createLibrary(this.libType, this.name, this.displayName, this.description, this.content);
                                LOGGER.log(Level.FINE, "Created library {0}", this.name);
                                this.removeFromListenerList(pcl);
                            }
                        }
                        catch (IOException | IllegalArgumentException ex) {
                            LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                        }
                    } else {
                        this.removeFromListenerList(pcl);
                    }
                }
            }
        }

        private void removeFromListenerList(final PropertyChangeListener pcl) {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JavaEEServerModuleFactory javaEEServerModuleFactory = singleton;
                    synchronized (javaEEServerModuleFactory) {
                        if (null != lmgr) {
                            lmgr.removePropertyChangeListener(pcl);
                            content = null;
                            name = null;
                        }
                    }
                }
            });
        }
    }
}

