/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.link.Link;
import org.primefaces.mobile.util.MobileUtils;
import org.primefaces.util.HTML;

public class LinkRenderer
extends org.primefaces.component.link.LinkRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Link link = (Link)component;
        boolean shouldWriteId = this.shouldWriteId((UIComponent)link);
        boolean disabled = link.isDisabled();
        String style = link.getStyle();
        String defaultStyleClass = disabled ? "ui-link ui-widget ui-state-disabled" : "ui-link ui-widget";
        String styleClass = link.getStyleClass();
        String string = styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        if (disabled) {
            writer.startElement("span", (UIComponent)link);
            if (shouldWriteId) {
                writer.writeAttribute("id", (Object)link.getClientId(context), "id");
            }
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            this.renderContent(context, link);
            writer.endElement("span");
        } else {
            String outcome = link.getOutcome();
            writer.startElement("a", (UIComponent)link);
            if (shouldWriteId) {
                writer.writeAttribute("id", (Object)link.getClientId(context), "id");
            }
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
            if (outcome != null && outcome.startsWith("pm:")) {
                String command = MobileUtils.buildNavigation(outcome) + "return false;";
                writer.writeAttribute("href", (Object)"#", null);
                this.renderPassThruAttributes(context, (UIComponent)link, HTML.LINK_ATTRS_WITHOUT_EVENTS);
                this.renderDomEvents(context, (UIComponent)link, HTML.OUTPUT_EVENTS_WITHOUT_CLICK);
                this.renderOnclick(context, component, command);
            } else {
                String targetURL = this.getTargetURL(context, link);
                if (targetURL == null) {
                    targetURL = "#";
                }
                writer.writeAttribute("href", (Object)targetURL, null);
                this.renderPassThruAttributes(context, (UIComponent)link, HTML.LINK_ATTRS_WITHOUT_EVENTS);
                this.renderDomEvents(context, (UIComponent)link, HTML.OUTPUT_EVENTS);
            }
            this.renderContent(context, link);
            writer.endElement("a");
        }
    }
}

