/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import java.util.logging.Logger;
import javax.faces.component.ContextCallback;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.event.PhaseId;
import org.primefaces.context.PrimePartialResponseWriter;
import org.primefaces.util.ComponentUtils;
import org.primefaces.visit.ResetInputContextCallback;
import org.primefaces.visit.ResetInputVisitCallback;

public class PrimePartialViewContext
extends PartialViewContextWrapper {
    private static final Logger LOG = Logger.getLogger(PrimePartialViewContext.class.getName());
    private PartialViewContext wrapped;
    private PartialResponseWriter writer = null;

    public PrimePartialViewContext(PartialViewContext wrapped) {
        this.wrapped = wrapped;
    }

    public PartialViewContext getWrapped() {
        return this.wrapped;
    }

    public void processPartial(PhaseId phaseId) {
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.resetValues(context);
        }
        this.getWrapped().processPartial(phaseId);
    }

    public void setPartialRequest(boolean value) {
        this.getWrapped().setPartialRequest(value);
    }

    public PartialResponseWriter getPartialResponseWriter() {
        if (this.writer == null) {
            PartialResponseWriter parentWriter = this.getWrapped().getPartialResponseWriter();
            this.writer = new PrimePartialResponseWriter(parentWriter);
        }
        return this.writer;
    }

    public boolean isAjaxRequest() {
        return this.getWrapped().isAjaxRequest() || FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey("javax.faces.partial.ajax");
    }

    public boolean isPartialRequest() {
        return this.getWrapped().isPartialRequest() || FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey("javax.faces.partial.execute");
    }

    private void resetValues(FacesContext context) {
        boolean resetValues;
        Object resetValuesObject = context.getExternalContext().getRequestParameterMap().get("primefaces.resetvalues");
        boolean bl = resetValues = null != resetValuesObject && "true".equals(resetValuesObject);
        if (resetValues) {
            VisitContext visitContext = null;
            ResetInputContextCallback contextCallback = null;
            for (String renderId : context.getPartialViewContext().getRenderIds()) {
                if (ComponentUtils.isValueBlank(renderId) || renderId.trim().equals("@none")) continue;
                if (visitContext == null) {
                    visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
                }
                if (renderId.equals("@all")) {
                    context.getViewRoot().visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
                    continue;
                }
                if (contextCallback == null) {
                    contextCallback = new ResetInputContextCallback(visitContext);
                }
                context.getViewRoot().invokeOnComponent(context, renderId, (ContextCallback)contextCallback);
            }
        }
    }
}

