/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.Image;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import javax.swing.GrayFilter;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.beans.beaninfo.BiAnalyser;
import org.netbeans.modules.beans.beaninfo.BiChildren;
import org.netbeans.modules.beans.beaninfo.BiExcludeAllAction;
import org.netbeans.modules.beans.beaninfo.BiFeature;
import org.netbeans.modules.beans.beaninfo.BiFeatureNode;
import org.netbeans.modules.beans.beaninfo.BiIconEditor;
import org.netbeans.modules.beans.beaninfo.BiIncludeAllAction;
import org.netbeans.modules.beans.beaninfo.GenerateBeanInfoAction;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class BiNode
extends AbstractNode {
    private static String ICON_BASE = "org/netbeans/modules/beans/resources/beanInfo.gif";
    private static String ICON_BASE_PATTERNS = "org/netbeans/modules/beans/resources/patternGroup.gif";
    private static String WAIT_ICON_BASE = "org/netbeans/modules/beans/resources/wait.gif";
    private static String WARNING_ICON_BASE = "org/netbeans/modules/beans/resources/warning.gif";
    private static String PROP_NULL_DESCRIPTOR = "nullDescriptor";
    private static String PROP_NULL_PROPERTIES = "nullProperties";
    private static String PROP_NULL_EVENTS = "nullEvents";
    private static String PROP_NULL_METHODS = "nullMethods";
    private static String PROP_LAZY_DESCRIPTOR = "lazyDescriptor";
    private static String PROP_LAZY_PROPERTIES = "lazyProperties";
    private static String PROP_LAZY_EVENTS = "lazyEvents";
    private static String PROP_LAZY_METHODS = "lazyMethods";
    private static String PROP_BI_ICON_C16 = "iconColor16x16";
    private static String PROP_BI_ICON_M16 = "iconMono16x16";
    private static String PROP_BI_ICON_C32 = "iconColor32x32";
    private static String PROP_BI_ICON_M32 = "iconMono32x32";
    private static String PROP_BI_DEFAULT_PROPERTY = "defaultPropertyIndex";
    private static String PROP_BI_DEFAULT_EVENT = "defaultEventIndex";
    private static String PROP_USE_SUPERCLASS = "useSuperclass";
    static GrayFilter grayFilter = null;
    private BiAnalyser biAnalyser;
    private PropertySupport[] descSubnodeDescriptor = new PropertySupport[]{new PropertySupport.ReadWrite<Boolean>(PROP_NULL_DESCRIPTOR, Boolean.TYPE, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_NULL_DESCRIPTOR), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_NULL_DESCRIPTOR)){

        public Boolean getValue() {
            return BiNode.this.biAnalyser.isNullDescriptor();
        }

        public void setValue(Boolean val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            try {
                BiNode.this.biAnalyser.setNullDescriptor(val);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException();
            }
            BiNode.this.iconChange();
        }
    }};
    private PropertySupport[] propSubnodeProperties = new PropertySupport[]{new PropertySupport.ReadWrite<Boolean>(PROP_NULL_PROPERTIES, Boolean.TYPE, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_NULL_PROPERTIES), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_NULL_PROPERTIES)){

        public Boolean getValue() {
            return BiNode.this.biAnalyser.isNullProperties();
        }

        public void setValue(Boolean val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            try {
                BiNode.this.biAnalyser.setNullProperties(val);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException();
            }
            BiNode.this.iconChange();
        }
    }};
    private PropertySupport[] eventSubnodeProperties = new PropertySupport[]{new PropertySupport.ReadWrite<Boolean>(PROP_NULL_EVENTS, Boolean.TYPE, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_NULL_EVENTS), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_NULL_EVENTS)){

        public Boolean getValue() {
            return BiNode.this.biAnalyser.isNullEventSets();
        }

        public void setValue(Boolean val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            try {
                BiNode.this.biAnalyser.setNullEventSets(val);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException();
            }
            BiNode.this.iconChange();
        }
    }};
    private PropertySupport[] methodSubnodeProperties = new PropertySupport[]{new PropertySupport.ReadWrite<Boolean>(PROP_NULL_PROPERTIES, Boolean.TYPE, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_NULL_METHODS), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_NULL_METHODS)){

        public Boolean getValue() {
            return BiNode.this.biAnalyser.isNullMethods();
        }

        public void setValue(Boolean val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            try {
                BiNode.this.biAnalyser.setNullMethods(val);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException();
            }
            BiNode.this.iconChange();
        }
    }};

    BiNode(final BiAnalyser biAnalyser) {
        super((Children)new Children.Array());
        Node[] nodeArray;
        this.biAnalyser = biAnalyser;
        this.setDisplayName(NbBundle.getBundle(BiNode.class).getString("CTL_NODE_BeanInfo"));
        this.setIconBaseWithExtension(ICON_BASE);
        if (biAnalyser.isOlderVersion()) {
            Node[] nodeArray2 = new Node[2];
            nodeArray2[0] = new SubNode(biAnalyser, new Class[]{BiFeature.Property.class, BiFeature.IdxProperty.class}, "CTL_NODE_Properties", ICON_BASE_PATTERNS, (Node.Property[])this.propSubnodeProperties, null);
            nodeArray = nodeArray2;
            nodeArray2[1] = new SubNode(biAnalyser, new Class[]{BiFeature.EventSet.class}, "CTL_NODE_EventSets", ICON_BASE_PATTERNS, (Node.Property[])this.eventSubnodeProperties, null);
        } else {
            Node[] nodeArray3 = new Node[4];
            nodeArray3[0] = new SubNode(biAnalyser, new Class[]{BiFeature.Descriptor.class}, "CTL_NODE_Descriptor", ICON_BASE_PATTERNS, (Node.Property[])this.descSubnodeDescriptor, new Node.Property[]{BiNode.createProperty(biAnalyser, Boolean.TYPE, PROP_LAZY_DESCRIPTOR, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_LAZY_DESCRIPTOR), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_LAZY_DESCRIPTOR), "isLazyDescriptor", "setLazyDescriptor")});
            nodeArray3[1] = new SubNode(biAnalyser, new Class[]{BiFeature.Property.class, BiFeature.IdxProperty.class}, "CTL_NODE_Properties", ICON_BASE_PATTERNS, (Node.Property[])this.propSubnodeProperties, new Node.Property[]{BiNode.createProperty(biAnalyser, Boolean.TYPE, PROP_LAZY_DESCRIPTOR, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_LAZY_PROPERTIES), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_LAZY_PROPERTIES), "isLazyProperties", "setLazyProperties")});
            nodeArray3[2] = new SubNode(biAnalyser, new Class[]{BiFeature.EventSet.class}, "CTL_NODE_EventSets", ICON_BASE_PATTERNS, (Node.Property[])this.eventSubnodeProperties, new Node.Property[]{BiNode.createProperty(biAnalyser, Boolean.TYPE, PROP_LAZY_EVENTS, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_LAZY_EVENTS), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_LAZY_EVENTS), "isLazyEventSets", "setLazyEventSets")});
            nodeArray = nodeArray3;
            nodeArray3[3] = new SubNode(biAnalyser, new Class[]{BiFeature.Method.class}, "CTL_NODE_Methods", ICON_BASE_PATTERNS, (Node.Property[])this.methodSubnodeProperties, new Node.Property[]{BiNode.createProperty(biAnalyser, Boolean.TYPE, PROP_LAZY_METHODS, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_LAZY_METHODS), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_LAZY_METHODS), "isLazyMethods", "setLazyMethods")});
        }
        Node[] subnodes = nodeArray;
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put((Node.Property)new ImagePropertySupportRW(PROP_BI_ICON_C16, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_BI_ICON_C16), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_BI_ICON_C16)){

            public BiIconEditor.BiImageIcon getValue() throws IllegalAccessException, InvocationTargetException {
                return biAnalyser.getIconC16() != null ? this.ie.iconFromText(biAnalyser.getIconC16()) : null;
            }

            public void setValue(BiIconEditor.BiImageIcon value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                biAnalyser.setIconC16(this.ie.textFromIcon(value));
            }
        });
        ps.put((Node.Property)new ImagePropertySupportRW(PROP_BI_ICON_M16, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_BI_ICON_M16), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_BI_ICON_M16)){

            public BiIconEditor.BiImageIcon getValue() throws IllegalAccessException, InvocationTargetException {
                return biAnalyser.getIconM16() != null ? this.ie.iconFromText(biAnalyser.getIconM16()) : null;
            }

            public void setValue(BiIconEditor.BiImageIcon value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                biAnalyser.setIconM16(this.ie.textFromIcon(value));
            }
        });
        ps.put((Node.Property)new ImagePropertySupportRW(PROP_BI_ICON_C32, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_BI_ICON_C32), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_BI_ICON_C32)){

            public BiIconEditor.BiImageIcon getValue() throws IllegalAccessException, InvocationTargetException {
                return biAnalyser.getIconC32() != null ? this.ie.iconFromText(biAnalyser.getIconC32()) : null;
            }

            public void setValue(BiIconEditor.BiImageIcon value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                biAnalyser.setIconC32(this.ie.textFromIcon(value));
            }
        });
        ps.put((Node.Property)new ImagePropertySupportRW(PROP_BI_ICON_M32, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_BI_ICON_M32), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_BI_ICON_M32)){

            public BiIconEditor.BiImageIcon getValue() throws IllegalAccessException, InvocationTargetException {
                return biAnalyser.getIconM32() != null ? this.ie.iconFromText(biAnalyser.getIconM32()) : null;
            }

            public void setValue(BiIconEditor.BiImageIcon value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                biAnalyser.setIconM32(this.ie.textFromIcon(value));
            }
        });
        ps.put(BiNode.createProperty(biAnalyser, Integer.TYPE, PROP_BI_DEFAULT_PROPERTY, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_BI_DEFAULT_PROPERTY), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_BI_DEFAULT_PROPERTY), "getDefaultPropertyIndex", "setDefaultPropertyIndex"));
        ps.put(BiNode.createProperty(biAnalyser, Integer.TYPE, PROP_BI_DEFAULT_EVENT, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_BI_DEFAULT_EVENT), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_BI_DEFAULT_EVENT), "getDefaultEventIndex", "setDefaultEventIndex"));
        if (biAnalyser.isSuperclassVersion()) {
            ps.put(BiNode.createProperty(biAnalyser, Boolean.TYPE, PROP_USE_SUPERCLASS, GenerateBeanInfoAction.getString("PROP_Bi_" + PROP_USE_SUPERCLASS), GenerateBeanInfoAction.getString("HINT_Bi_" + PROP_USE_SUPERCLASS), "isUseSuperClass", "setUseSuperClass"));
        }
        this.setSheet(sheet);
        ((Children.Array)this.getChildren()).add(subnodes);
    }

    public void iconChange() {
        Node[] nodes = ((Children.Array)this.getChildren()).getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            ((SubNode)nodes[i]).iconChanged();
        }
    }

    public static Node createNoSourceNode(FileObject bi) {
        Object name = bi.getName();
        name = ((String)name).substring(0, ((String)name).length() - "BeanInfo".length());
        String ext = bi.getExt();
        if (ext.length() > 0) {
            name = (String)name + "." + ext;
        }
        String msg = NbBundle.getMessage(BiNode.class, (String)"CTL_NODE_MissingBeanFile", (Object)name);
        return new Error(msg);
    }

    public static Node createBiNode(BiAnalyser bia, NotifyDescriptor error) {
        if (bia == null) {
            Object msg = error == null ? NbBundle.getMessage(BiNode.class, (String)"CTL_NODE_UnknownBeanInfoState") : error.getMessage();
            return new Error(msg.toString());
        }
        if (bia.isBeanBroken()) {
            String msg = NbBundle.getMessage(BiNode.class, (String)"MSG_BrokenBean", (Object)bia.bis.getSourceDataObject().getPrimaryFile().getNameExt());
            return new Error(msg);
        }
        if (!bia.bis.isNbBeanInfo()) {
            String msg = NbBundle.getMessage(BiNode.class, (String)"CTL_NODE_UnknownBeanInfoFormat");
            return new Error(msg);
        }
        if (bia.bis.getSourceDataObject() == null) {
            return BiNode.createNoSourceNode(bia.bis.getDataObject().getPrimaryFile());
        }
        return new BiNode(bia);
    }

    public static <T> Node.Property<T> createProperty(Object inst, Class<T> type, String name, String dispName, String shortDesc, String getter, String setter) {
        PropertySupport.Reflection prop;
        try {
            prop = new PropertySupport.Reflection(inst, type, getter, setter);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage() + " " + getter);
        }
        prop.setName(name);
        prop.setDisplayName(dispName);
        prop.setShortDescription(shortDesc);
        return prop;
    }

    static {
        grayFilter = new GrayFilter(true, 5);
    }

    static final class SubNode
    extends AbstractNode
    implements Node.Cookie {
        private BiAnalyser biAnalyser;
        private Class<?> key;

        SubNode(BiAnalyser biAnalyser, Class<?>[] keys, String titleKey, String iconBase, Node.Property[] properties, Node.Property[] expert) {
            super((Children)new BiChildren(biAnalyser, keys));
            this.setDisplayName(NbBundle.getBundle(BiNode.class).getString(titleKey));
            this.setIconBaseWithExtension(iconBase);
            this.biAnalyser = biAnalyser;
            this.key = keys[0];
            Sheet sheet = Sheet.createDefault();
            Sheet.Set ps = sheet.get("properties");
            for (int i = 0; i < properties.length; ++i) {
                ps.put(properties[i]);
            }
            if (expert != null) {
                Sheet.Set eps = Sheet.createExpertSet();
                for (int i = 0; i < expert.length; ++i) {
                    eps.put(expert[i]);
                }
                sheet.put(eps);
            }
            this.setSheet(sheet);
            this.getCookieSet().add((Node.Cookie)this);
        }

        public Image getIcon(int type) {
            if (this.key == BiFeature.Descriptor.class && this.biAnalyser.isNullDescriptor()) {
                return GrayFilter.createDisabledImage(super.getIcon(type));
            }
            if (this.key == BiFeature.Property.class && this.biAnalyser.isNullProperties()) {
                return GrayFilter.createDisabledImage(super.getIcon(type));
            }
            if (this.key == BiFeature.EventSet.class && this.biAnalyser.isNullEventSets()) {
                return GrayFilter.createDisabledImage(super.getIcon(type));
            }
            if (this.key == BiFeature.Method.class && this.biAnalyser.isNullMethods()) {
                return GrayFilter.createDisabledImage(super.getIcon(type));
            }
            return super.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            if (this.key == BiFeature.Descriptor.class && this.biAnalyser.isNullDescriptor()) {
                return GrayFilter.createDisabledImage(super.getIcon(type));
            }
            if (this.key == BiFeature.Property.class && this.biAnalyser.isNullProperties()) {
                return GrayFilter.createDisabledImage(super.getIcon(type));
            }
            if (this.key == BiFeature.EventSet.class && this.biAnalyser.isNullEventSets()) {
                return GrayFilter.createDisabledImage(super.getIcon(type));
            }
            if (this.key == BiFeature.Method.class && this.biAnalyser.isNullMethods()) {
                return GrayFilter.createDisabledImage(super.getIcon(type));
            }
            return super.getOpenedIcon(type);
        }

        public Action[] getActions(boolean context) {
            if (context) {
                return super.getActions(true);
            }
            Children ch = this.getChildren();
            Node[] nodes = ch.getNodes();
            if (nodes == null) {
                return new SystemAction[0];
            }
            if (nodes.length == 0 || nodes[0] != null && ((BiFeatureNode)nodes[0]).getBiFeature() instanceof BiFeature.Descriptor) {
                return new SystemAction[0];
            }
            return new SystemAction[]{SystemAction.get(BiIncludeAllAction.class), SystemAction.get(BiExcludeAllAction.class), null};
        }

        void includeAll(boolean value) {
            Children ch = this.getChildren();
            Node[] nodes = ch.getNodes();
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < nodes.length; ++i) {
                ((BiFeatureNode)nodes[i]).include(value);
            }
        }

        public void iconChanged() {
            this.fireIconChange();
            this.fireOpenedIconChange();
            Children ch = this.getChildren();
            Node[] nodes = ch.getNodes();
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < nodes.length; ++i) {
                ((BiFeatureNode)nodes[i]).iconChanged();
            }
        }
    }

    private static final class Error
    extends AbstractNode {
        Error(String name) {
            super(Children.LEAF);
            this.setDisplayName(name);
            this.setIconBaseWithExtension(WARNING_ICON_BASE);
        }
    }

    abstract class ImagePropertySupportRW
    extends PropertySupport.ReadWrite<BiIconEditor.BiImageIcon> {
        BiIconEditor ie;

        ImagePropertySupportRW(String name, String displayName, String shortDescription) {
            super(name, BiIconEditor.BiImageIcon.class, displayName, shortDescription);
            this.ie = null;
            this.ie = new BiIconEditor(BiNode.this.biAnalyser.bis.getSourceDataObject().getPrimaryFile());
        }

        public PropertyEditor getPropertyEditor() {
            return this.ie;
        }
    }

    static final class Wait
    extends AbstractNode {
        Wait() {
            super(Children.LEAF);
            this.setDisplayName(SourceUtils.isScanInProgress() ? NbBundle.getBundle(BiNode.class).getString("CTL_NODE_WaitScan") : NbBundle.getBundle(BiNode.class).getString("CTL_NODE_Wait"));
            this.setIconBaseWithExtension(WAIT_ICON_BASE);
        }
    }
}

