// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSummaryDataPoint_ValueAtQuantile(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint_ValueAtQuantile() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigSummaryDataPoint_ValueAtQuantile()
				CopyOrigSummaryDataPoint_ValueAtQuantile(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigSummaryDataPoint_ValueAtQuantile(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigSummaryDataPoint_ValueAtQuantileUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigSummaryDataPoint_ValueAtQuantile()
	UnmarshalJSONOrigSummaryDataPoint_ValueAtQuantile(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigSummaryDataPoint_ValueAtQuantile(), dest)
}

func TestMarshalAndUnmarshalJSONOrigSummaryDataPoint_ValueAtQuantile(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint_ValueAtQuantile() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigSummaryDataPoint_ValueAtQuantile(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigSummaryDataPoint_ValueAtQuantile()
				UnmarshalJSONOrigSummaryDataPoint_ValueAtQuantile(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigSummaryDataPoint_ValueAtQuantile(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigSummaryDataPoint_ValueAtQuantileFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSummaryDataPoint_ValueAtQuantile() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigSummaryDataPoint_ValueAtQuantile()
			require.Error(t, UnmarshalProtoOrigSummaryDataPoint_ValueAtQuantile(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSummaryDataPoint_ValueAtQuantileUnknown(t *testing.T) {
	dest := NewOrigSummaryDataPoint_ValueAtQuantile()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigSummaryDataPoint_ValueAtQuantile(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigSummaryDataPoint_ValueAtQuantile(), dest)
}

func TestMarshalAndUnmarshalProtoOrigSummaryDataPoint_ValueAtQuantile(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint_ValueAtQuantile() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigSummaryDataPoint_ValueAtQuantile(src))
				gotSize := MarshalProtoOrigSummaryDataPoint_ValueAtQuantile(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigSummaryDataPoint_ValueAtQuantile()
				require.NoError(t, UnmarshalProtoOrigSummaryDataPoint_ValueAtQuantile(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigSummaryDataPoint_ValueAtQuantile(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSummaryDataPoint_ValueAtQuantile(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint_ValueAtQuantile() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSummaryDataPoint_ValueAtQuantile(src))
			gotSize := MarshalProtoOrigSummaryDataPoint_ValueAtQuantile(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.SummaryDataPoint_ValueAtQuantile{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigSummaryDataPoint_ValueAtQuantile()
			require.NoError(t, UnmarshalProtoOrigSummaryDataPoint_ValueAtQuantile(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSummaryDataPoint_ValueAtQuantile() map[string][]byte {
	return map[string][]byte{
		"invalid_field":            {0x02},
		"Quantile/wrong_wire_type": {0xc},
		"Quantile/missing_value":   {0x9},
		"Value/wrong_wire_type":    {0x14},
		"Value/missing_value":      {0x11},
	}
}

func genTestEncodingValuesSummaryDataPoint_ValueAtQuantile() map[string]*otlpmetrics.SummaryDataPoint_ValueAtQuantile {
	return map[string]*otlpmetrics.SummaryDataPoint_ValueAtQuantile{
		"empty":         NewOrigSummaryDataPoint_ValueAtQuantile(),
		"Quantile/test": {Quantile: float64(3.1415926)},
		"Value/test":    {Value: float64(3.1415926)},
	}
}
