/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.BoundedGene;
import java.io.Serializable;
import java.util.Objects;

abstract class AbstractBoundedGene<A extends Comparable<? super A>, G extends AbstractBoundedGene<A, G>>
implements BoundedGene<A, G>,
Serializable {
    private static final long serialVersionUID = 1L;
    final A _min;
    final A _max;
    final A _value;

    protected AbstractBoundedGene(A value, A min, A max) {
        this._min = (Comparable)Objects.requireNonNull(min, "Min value not be null.");
        this._max = (Comparable)Objects.requireNonNull(max, "Max value must not be null.");
        this._value = (Comparable)Objects.requireNonNull(value, "Gene value must not be null.");
    }

    @Override
    public A getAllele() {
        return this._value;
    }

    @Override
    public A getMin() {
        return this._min;
    }

    @Override
    public A getMax() {
        return this._max;
    }

    @Override
    public boolean isValid() {
        return this._value.compareTo(this._min) >= 0 && this._value.compareTo(this._max) <= 0;
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * Objects.hashCode(this._value) + 37;
        hash += 31 * Objects.hashCode(this._min) + 37;
        return hash += 31 * Objects.hashCode(this._max) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AbstractBoundedGene && Objects.equals(((AbstractBoundedGene)obj)._value, this._value) && Objects.equals(((AbstractBoundedGene)obj)._min, this._min) && Objects.equals(((AbstractBoundedGene)obj)._max, this._max);
    }

    public String toString() {
        return String.format("[%s]", this._value);
    }
}

