// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopySample(t *testing.T) {
	for name, src := range genTestEncodingValuesSample() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewSample()
				CopySample(dest, src)
				assert.Equal(t, src, dest)
				CopySample(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopySampleSlice(t *testing.T) {
	src := []Sample{}
	dest := []Sample{}
	// Test CopyTo empty
	dest = CopySampleSlice(dest, src)
	assert.Equal(t, []Sample{}, dest)

	// Test CopyTo larger slice
	src = GenTestSampleSlice()
	dest = CopySampleSlice(dest, src)
	assert.Equal(t, GenTestSampleSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySampleSlice(dest, src)
	assert.Equal(t, GenTestSampleSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySampleSlice(dest, []Sample{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySampleSlice(dest, src)
	assert.Equal(t, GenTestSampleSlice(), dest)
}

func TestCopySamplePtrSlice(t *testing.T) {
	src := []*Sample{}
	dest := []*Sample{}
	// Test CopyTo empty
	dest = CopySamplePtrSlice(dest, src)
	assert.Equal(t, []*Sample{}, dest)

	// Test CopyTo larger slice
	src = GenTestSamplePtrSlice()
	dest = CopySamplePtrSlice(dest, src)
	assert.Equal(t, GenTestSamplePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySamplePtrSlice(dest, src)
	assert.Equal(t, GenTestSamplePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySamplePtrSlice(dest, []*Sample{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySamplePtrSlice(dest, src)
	assert.Equal(t, GenTestSamplePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONSampleUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewSample()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewSample(), dest)
}

func TestMarshalAndUnmarshalJSONSample(t *testing.T) {
	for name, src := range genTestEncodingValuesSample() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewSample()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteSample(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoSampleFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSample() {
		t.Run(name, func(t *testing.T) {
			dest := NewSample()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoSampleUnknown(t *testing.T) {
	dest := NewSample()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewSample(), dest)
}

func TestMarshalAndUnmarshalProtoSample(t *testing.T) {
	for name, src := range genTestEncodingValuesSample() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewSample()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteSample(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSample(t *testing.T) {
	for name, src := range genTestEncodingValuesSample() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Sample{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewSample()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSample() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                      {0x02},
		"StackIndex/wrong_wire_type":         {0xc},
		"StackIndex/missing_value":           {0x8},
		"Values/wrong_wire_type":             {0x14},
		"Values/missing_value":               {0x12},
		"AttributeIndices/wrong_wire_type":   {0x1c},
		"AttributeIndices/missing_value":     {0x1a},
		"LinkIndex/wrong_wire_type":          {0x24},
		"LinkIndex/missing_value":            {0x20},
		"TimestampsUnixNano/wrong_wire_type": {0x2c},
		"TimestampsUnixNano/missing_value":   {0x2a},
	}
}

func genTestEncodingValuesSample() map[string]*Sample {
	return map[string]*Sample{
		"empty":                   NewSample(),
		"StackIndex/test":         {StackIndex: int32(13)},
		"Values/test":             {Values: []int64{int64(0), int64(13)}},
		"AttributeIndices/test":   {AttributeIndices: []int32{int32(0), int32(13)}},
		"LinkIndex/test":          {LinkIndex: int32(13)},
		"TimestampsUnixNano/test": {TimestampsUnixNano: []uint64{uint64(0), uint64(13)}},
	}
}
