// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlplogs "go.opentelemetry.io/proto/slim/otlp/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyLogRecord(t *testing.T) {
	for name, src := range genTestEncodingValuesLogRecord() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewLogRecord()
				CopyLogRecord(dest, src)
				assert.Equal(t, src, dest)
				CopyLogRecord(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyLogRecordSlice(t *testing.T) {
	src := []LogRecord{}
	dest := []LogRecord{}
	// Test CopyTo empty
	dest = CopyLogRecordSlice(dest, src)
	assert.Equal(t, []LogRecord{}, dest)

	// Test CopyTo larger slice
	src = GenTestLogRecordSlice()
	dest = CopyLogRecordSlice(dest, src)
	assert.Equal(t, GenTestLogRecordSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLogRecordSlice(dest, src)
	assert.Equal(t, GenTestLogRecordSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLogRecordSlice(dest, []LogRecord{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLogRecordSlice(dest, src)
	assert.Equal(t, GenTestLogRecordSlice(), dest)
}

func TestCopyLogRecordPtrSlice(t *testing.T) {
	src := []*LogRecord{}
	dest := []*LogRecord{}
	// Test CopyTo empty
	dest = CopyLogRecordPtrSlice(dest, src)
	assert.Equal(t, []*LogRecord{}, dest)

	// Test CopyTo larger slice
	src = GenTestLogRecordPtrSlice()
	dest = CopyLogRecordPtrSlice(dest, src)
	assert.Equal(t, GenTestLogRecordPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLogRecordPtrSlice(dest, src)
	assert.Equal(t, GenTestLogRecordPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLogRecordPtrSlice(dest, []*LogRecord{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLogRecordPtrSlice(dest, src)
	assert.Equal(t, GenTestLogRecordPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONLogRecordUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewLogRecord()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewLogRecord(), dest)
}

func TestMarshalAndUnmarshalJSONLogRecord(t *testing.T) {
	for name, src := range genTestEncodingValuesLogRecord() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewLogRecord()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteLogRecord(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoLogRecordFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesLogRecord() {
		t.Run(name, func(t *testing.T) {
			dest := NewLogRecord()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoLogRecordUnknown(t *testing.T) {
	dest := NewLogRecord()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewLogRecord(), dest)
}

func TestMarshalAndUnmarshalProtoLogRecord(t *testing.T) {
	for name, src := range genTestEncodingValuesLogRecord() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewLogRecord()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteLogRecord(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufLogRecord(t *testing.T) {
	for name, src := range genTestEncodingValuesLogRecord() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlplogs.LogRecord{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewLogRecord()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesLogRecord() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"TimeUnixNano/wrong_wire_type":           {0xc},
		"TimeUnixNano/missing_value":             {0x9},
		"ObservedTimeUnixNano/wrong_wire_type":   {0x5c},
		"ObservedTimeUnixNano/missing_value":     {0x59},
		"SeverityNumber/wrong_wire_type":         {0x14},
		"SeverityNumber/missing_value":           {0x10},
		"SeverityText/wrong_wire_type":           {0x1c},
		"SeverityText/missing_value":             {0x1a},
		"Body/wrong_wire_type":                   {0x2c},
		"Body/missing_value":                     {0x2a},
		"Attributes/wrong_wire_type":             {0x34},
		"Attributes/missing_value":               {0x32},
		"DroppedAttributesCount/wrong_wire_type": {0x3c},
		"DroppedAttributesCount/missing_value":   {0x38},
		"Flags/wrong_wire_type":                  {0x44},
		"Flags/missing_value":                    {0x45},
		"TraceId/wrong_wire_type":                {0x4c},
		"TraceId/missing_value":                  {0x4a},
		"SpanId/wrong_wire_type":                 {0x54},
		"SpanId/missing_value":                   {0x52},
		"EventName/wrong_wire_type":              {0x64},
		"EventName/missing_value":                {0x62},
	}
}

func genTestEncodingValuesLogRecord() map[string]*LogRecord {
	return map[string]*LogRecord{
		"empty":                       NewLogRecord(),
		"TimeUnixNano/test":           {TimeUnixNano: uint64(13)},
		"ObservedTimeUnixNano/test":   {ObservedTimeUnixNano: uint64(13)},
		"SeverityNumber/test":         {SeverityNumber: SeverityNumber(13)},
		"SeverityText/test":           {SeverityText: "test_severitytext"},
		"Body/test":                   {Body: *GenTestAnyValue()},
		"Attributes/test":             {Attributes: []KeyValue{{}, *GenTestKeyValue()}},
		"DroppedAttributesCount/test": {DroppedAttributesCount: uint32(13)},
		"Flags/test":                  {Flags: uint32(13)},
		"TraceId/test":                {TraceId: *GenTestTraceID()},
		"SpanId/test":                 {SpanId: *GenTestSpanID()},
		"EventName/test":              {EventName: "test_eventname"},
	}
}
