# Go API client for edgefirewall

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 2.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```golang
import edgefirewall "github.com/GIT_USER_ID/GIT_REPO_ID"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```golang
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `sw.ContextServerIndex` of type `int`.

```golang
ctx := context.WithValue(context.Background(), edgefirewall.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `sw.ContextServerVariables` of type `map[string]string`.

```golang
ctx := context.WithValue(context.Background(), edgefirewall.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `sw.ContextOperationServerIndices` and `sw.ContextOperationServerVariables` context maps.

```golang
ctx := context.WithValue(context.Background(), edgefirewall.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), edgefirewall.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *https://api.azionapi.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultAPI* | [**EdgeFirewallEdgeFirewallIdRulesEngineGet**](docs/DefaultAPI.md#edgefirewalledgefirewallidrulesengineget) | **Get** /edge_firewall/{edge_firewall_id}/rules_engine | List all rule sets.
*DefaultAPI* | [**EdgeFirewallEdgeFirewallIdRulesEnginePost**](docs/DefaultAPI.md#edgefirewalledgefirewallidrulesenginepost) | **Post** /edge_firewall/{edge_firewall_id}/rules_engine | Create rule set.
*DefaultAPI* | [**EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdDelete**](docs/DefaultAPI.md#edgefirewalledgefirewallidrulesenginerulesetiddelete) | **Delete** /edge_firewall/{edge_firewall_id}/rules_engine/{rule_set_id} | Delete rule set.
*DefaultAPI* | [**EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdGet**](docs/DefaultAPI.md#edgefirewalledgefirewallidrulesenginerulesetidget) | **Get** /edge_firewall/{edge_firewall_id}/rules_engine/{rule_set_id} | Retrieve rule set by ID.
*DefaultAPI* | [**EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPatch**](docs/DefaultAPI.md#edgefirewalledgefirewallidrulesenginerulesetidpatch) | **Patch** /edge_firewall/{edge_firewall_id}/rules_engine/{rule_set_id} | Edit rule set.
*DefaultAPI* | [**EdgeFirewallEdgeFirewallIdRulesEngineRuleSetIdPut**](docs/DefaultAPI.md#edgefirewalledgefirewallidrulesenginerulesetidput) | **Put** /edge_firewall/{edge_firewall_id}/rules_engine/{rule_set_id} | Overwrite rule set
*DefaultAPI* | [**EdgeFirewallGet**](docs/DefaultAPI.md#edgefirewallget) | **Get** /edge_firewall | List all user edge firewall
*DefaultAPI* | [**EdgeFirewallPost**](docs/DefaultAPI.md#edgefirewallpost) | **Post** /edge_firewall | Create a edge firewall
*DefaultAPI* | [**EdgeFirewallUuidDelete**](docs/DefaultAPI.md#edgefirewalluuiddelete) | **Delete** /edge_firewall/{uuid} | Delete an edge firewall by uuid
*DefaultAPI* | [**EdgeFirewallUuidGet**](docs/DefaultAPI.md#edgefirewalluuidget) | **Get** /edge_firewall/{uuid} | Retrieve an edge firewall set by uuid
*DefaultAPI* | [**EdgeFirewallUuidPatch**](docs/DefaultAPI.md#edgefirewalluuidpatch) | **Patch** /edge_firewall/{uuid} | Update some edge firewall attributes, like \&quot;active\&quot;
*DefaultAPI* | [**EdgeFirewallUuidPut**](docs/DefaultAPI.md#edgefirewalluuidput) | **Put** /edge_firewall/{uuid} | Overwrite some edge firewall attributes, like \&quot;active\&quot;


## Documentation For Models

 - [Behaviors](docs/Behaviors.md)
 - [Conditionals](docs/Conditionals.md)
 - [CreateEdgeFirewallRequest](docs/CreateEdgeFirewallRequest.md)
 - [CreateRuleSetRequest](docs/CreateRuleSetRequest.md)
 - [EdgeFirewall](docs/EdgeFirewall.md)
 - [EdgeFirewallResponse](docs/EdgeFirewallResponse.md)
 - [Links](docs/Links.md)
 - [ListEdgeFirewallResponse](docs/ListEdgeFirewallResponse.md)
 - [NullArgumentBehavior](docs/NullArgumentBehavior.md)
 - [RuleSetResponse](docs/RuleSetResponse.md)
 - [RuleSetResponseAll](docs/RuleSetResponseAll.md)
 - [RuleSetResult](docs/RuleSetResult.md)
 - [RuleSetResultAll](docs/RuleSetResultAll.md)
 - [RuleSetResultResults](docs/RuleSetResultResults.md)
 - [SSLVerificationStatusArguments](docs/SSLVerificationStatusArguments.md)
 - [SSLVerificationStatusCriteria](docs/SSLVerificationStatusCriteria.md)
 - [SSLVerificationStatusOperators](docs/SSLVerificationStatusOperators.md)
 - [SetCustomResponse](docs/SetCustomResponse.md)
 - [SetCustomResponseArgument](docs/SetCustomResponseArgument.md)
 - [SetCustomResponseArgumentStatusCode](docs/SetCustomResponseArgumentStatusCode.md)
 - [SetRateLimitBehavior](docs/SetRateLimitBehavior.md)
 - [SetRateLimitBehaviorArgument](docs/SetRateLimitBehaviorArgument.md)
 - [SetRateLimitBehaviorArgumentAverageRateLimit](docs/SetRateLimitBehaviorArgumentAverageRateLimit.md)
 - [SetWAFRuleSetAndWafModeBehavior](docs/SetWAFRuleSetAndWafModeBehavior.md)
 - [SetWAFRuleSetAndWafModeBehaviorArgument](docs/SetWAFRuleSetAndWafModeBehaviorArgument.md)
 - [SetWAFRuleSetBehavior](docs/SetWAFRuleSetBehavior.md)
 - [SetWAFRuleSetBehaviorArgument](docs/SetWAFRuleSetBehaviorArgument.md)
 - [SimpleArgumentBehavior](docs/SimpleArgumentBehavior.md)
 - [SimpleArgumentBehaviorArgument](docs/SimpleArgumentBehaviorArgument.md)
 - [UpdateEdgeFirewallRequest](docs/UpdateEdgeFirewallRequest.md)
 - [Variables](docs/Variables.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### tokenAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

Note, each API key must be added to a map of `map[string]APIKey` where the key is: Authorization and passed in as the auth context for each request.

Example

```golang
auth := context.WithValue(
		context.Background(),
		sw.ContextAPIKeys,
		map[string]sw.APIKey{
			"Authorization": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author



