// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/binaryauthorization/v1/service.proto

package binaryauthorizationpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	BinauthzManagementServiceV1_GetPolicy_FullMethodName      = "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/GetPolicy"
	BinauthzManagementServiceV1_UpdatePolicy_FullMethodName   = "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/UpdatePolicy"
	BinauthzManagementServiceV1_CreateAttestor_FullMethodName = "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/CreateAttestor"
	BinauthzManagementServiceV1_GetAttestor_FullMethodName    = "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/GetAttestor"
	BinauthzManagementServiceV1_UpdateAttestor_FullMethodName = "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/UpdateAttestor"
	BinauthzManagementServiceV1_ListAttestors_FullMethodName  = "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/ListAttestors"
	BinauthzManagementServiceV1_DeleteAttestor_FullMethodName = "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/DeleteAttestor"
)

// BinauthzManagementServiceV1Client is the client API for BinauthzManagementServiceV1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BinauthzManagementServiceV1Client interface {
	// A [policy][google.cloud.binaryauthorization.v1.Policy] specifies the [attestors][google.cloud.binaryauthorization.v1.Attestor] that must attest to
	// a container image, before the project is allowed to deploy that
	// image. There is at most one policy per project. All image admission
	// requests are permitted if a project has no policy.
	//
	// Gets the [policy][google.cloud.binaryauthorization.v1.Policy] for this project. Returns a default
	// [policy][google.cloud.binaryauthorization.v1.Policy] if the project does not have one.
	GetPolicy(ctx context.Context, in *GetPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates or updates a project's [policy][google.cloud.binaryauthorization.v1.Policy], and returns a copy of the
	// new [policy][google.cloud.binaryauthorization.v1.Policy]. A policy is always updated as a whole, to avoid race
	// conditions with concurrent policy enforcement (or management!)
	// requests. Returns NOT_FOUND if the project does not exist, INVALID_ARGUMENT
	// if the request is malformed.
	UpdatePolicy(ctx context.Context, in *UpdatePolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates an [attestor][google.cloud.binaryauthorization.v1.Attestor], and returns a copy of the new
	// [attestor][google.cloud.binaryauthorization.v1.Attestor]. Returns NOT_FOUND if the project does not exist,
	// INVALID_ARGUMENT if the request is malformed, ALREADY_EXISTS if the
	// [attestor][google.cloud.binaryauthorization.v1.Attestor] already exists.
	CreateAttestor(ctx context.Context, in *CreateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error)
	// Gets an [attestor][google.cloud.binaryauthorization.v1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	GetAttestor(ctx context.Context, in *GetAttestorRequest, opts ...grpc.CallOption) (*Attestor, error)
	// Updates an [attestor][google.cloud.binaryauthorization.v1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	UpdateAttestor(ctx context.Context, in *UpdateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error)
	// Lists [attestors][google.cloud.binaryauthorization.v1.Attestor].
	// Returns INVALID_ARGUMENT if the project does not exist.
	ListAttestors(ctx context.Context, in *ListAttestorsRequest, opts ...grpc.CallOption) (*ListAttestorsResponse, error)
	// Deletes an [attestor][google.cloud.binaryauthorization.v1.Attestor]. Returns NOT_FOUND if the
	// [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	DeleteAttestor(ctx context.Context, in *DeleteAttestorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type binauthzManagementServiceV1Client struct {
	cc grpc.ClientConnInterface
}

func NewBinauthzManagementServiceV1Client(cc grpc.ClientConnInterface) BinauthzManagementServiceV1Client {
	return &binauthzManagementServiceV1Client{cc}
}

func (c *binauthzManagementServiceV1Client) GetPolicy(ctx context.Context, in *GetPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, BinauthzManagementServiceV1_GetPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) UpdatePolicy(ctx context.Context, in *UpdatePolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, BinauthzManagementServiceV1_UpdatePolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) CreateAttestor(ctx context.Context, in *CreateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error) {
	out := new(Attestor)
	err := c.cc.Invoke(ctx, BinauthzManagementServiceV1_CreateAttestor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) GetAttestor(ctx context.Context, in *GetAttestorRequest, opts ...grpc.CallOption) (*Attestor, error) {
	out := new(Attestor)
	err := c.cc.Invoke(ctx, BinauthzManagementServiceV1_GetAttestor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) UpdateAttestor(ctx context.Context, in *UpdateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error) {
	out := new(Attestor)
	err := c.cc.Invoke(ctx, BinauthzManagementServiceV1_UpdateAttestor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) ListAttestors(ctx context.Context, in *ListAttestorsRequest, opts ...grpc.CallOption) (*ListAttestorsResponse, error) {
	out := new(ListAttestorsResponse)
	err := c.cc.Invoke(ctx, BinauthzManagementServiceV1_ListAttestors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) DeleteAttestor(ctx context.Context, in *DeleteAttestorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BinauthzManagementServiceV1_DeleteAttestor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BinauthzManagementServiceV1Server is the server API for BinauthzManagementServiceV1 service.
// All implementations should embed UnimplementedBinauthzManagementServiceV1Server
// for forward compatibility
type BinauthzManagementServiceV1Server interface {
	// A [policy][google.cloud.binaryauthorization.v1.Policy] specifies the [attestors][google.cloud.binaryauthorization.v1.Attestor] that must attest to
	// a container image, before the project is allowed to deploy that
	// image. There is at most one policy per project. All image admission
	// requests are permitted if a project has no policy.
	//
	// Gets the [policy][google.cloud.binaryauthorization.v1.Policy] for this project. Returns a default
	// [policy][google.cloud.binaryauthorization.v1.Policy] if the project does not have one.
	GetPolicy(context.Context, *GetPolicyRequest) (*Policy, error)
	// Creates or updates a project's [policy][google.cloud.binaryauthorization.v1.Policy], and returns a copy of the
	// new [policy][google.cloud.binaryauthorization.v1.Policy]. A policy is always updated as a whole, to avoid race
	// conditions with concurrent policy enforcement (or management!)
	// requests. Returns NOT_FOUND if the project does not exist, INVALID_ARGUMENT
	// if the request is malformed.
	UpdatePolicy(context.Context, *UpdatePolicyRequest) (*Policy, error)
	// Creates an [attestor][google.cloud.binaryauthorization.v1.Attestor], and returns a copy of the new
	// [attestor][google.cloud.binaryauthorization.v1.Attestor]. Returns NOT_FOUND if the project does not exist,
	// INVALID_ARGUMENT if the request is malformed, ALREADY_EXISTS if the
	// [attestor][google.cloud.binaryauthorization.v1.Attestor] already exists.
	CreateAttestor(context.Context, *CreateAttestorRequest) (*Attestor, error)
	// Gets an [attestor][google.cloud.binaryauthorization.v1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	GetAttestor(context.Context, *GetAttestorRequest) (*Attestor, error)
	// Updates an [attestor][google.cloud.binaryauthorization.v1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	UpdateAttestor(context.Context, *UpdateAttestorRequest) (*Attestor, error)
	// Lists [attestors][google.cloud.binaryauthorization.v1.Attestor].
	// Returns INVALID_ARGUMENT if the project does not exist.
	ListAttestors(context.Context, *ListAttestorsRequest) (*ListAttestorsResponse, error)
	// Deletes an [attestor][google.cloud.binaryauthorization.v1.Attestor]. Returns NOT_FOUND if the
	// [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	DeleteAttestor(context.Context, *DeleteAttestorRequest) (*emptypb.Empty, error)
}

// UnimplementedBinauthzManagementServiceV1Server should be embedded to have forward compatible implementations.
type UnimplementedBinauthzManagementServiceV1Server struct {
}

func (UnimplementedBinauthzManagementServiceV1Server) GetPolicy(context.Context, *GetPolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicy not implemented")
}
func (UnimplementedBinauthzManagementServiceV1Server) UpdatePolicy(context.Context, *UpdatePolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePolicy not implemented")
}
func (UnimplementedBinauthzManagementServiceV1Server) CreateAttestor(context.Context, *CreateAttestorRequest) (*Attestor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAttestor not implemented")
}
func (UnimplementedBinauthzManagementServiceV1Server) GetAttestor(context.Context, *GetAttestorRequest) (*Attestor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttestor not implemented")
}
func (UnimplementedBinauthzManagementServiceV1Server) UpdateAttestor(context.Context, *UpdateAttestorRequest) (*Attestor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAttestor not implemented")
}
func (UnimplementedBinauthzManagementServiceV1Server) ListAttestors(context.Context, *ListAttestorsRequest) (*ListAttestorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAttestors not implemented")
}
func (UnimplementedBinauthzManagementServiceV1Server) DeleteAttestor(context.Context, *DeleteAttestorRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAttestor not implemented")
}

// UnsafeBinauthzManagementServiceV1Server may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BinauthzManagementServiceV1Server will
// result in compilation errors.
type UnsafeBinauthzManagementServiceV1Server interface {
	mustEmbedUnimplementedBinauthzManagementServiceV1Server()
}

func RegisterBinauthzManagementServiceV1Server(s grpc.ServiceRegistrar, srv BinauthzManagementServiceV1Server) {
	s.RegisterService(&BinauthzManagementServiceV1_ServiceDesc, srv)
}

func _BinauthzManagementServiceV1_GetPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).GetPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BinauthzManagementServiceV1_GetPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).GetPolicy(ctx, req.(*GetPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_UpdatePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).UpdatePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BinauthzManagementServiceV1_UpdatePolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).UpdatePolicy(ctx, req.(*UpdatePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_CreateAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).CreateAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BinauthzManagementServiceV1_CreateAttestor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).CreateAttestor(ctx, req.(*CreateAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_GetAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).GetAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BinauthzManagementServiceV1_GetAttestor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).GetAttestor(ctx, req.(*GetAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_UpdateAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).UpdateAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BinauthzManagementServiceV1_UpdateAttestor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).UpdateAttestor(ctx, req.(*UpdateAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_ListAttestors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAttestorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).ListAttestors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BinauthzManagementServiceV1_ListAttestors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).ListAttestors(ctx, req.(*ListAttestorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_DeleteAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).DeleteAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BinauthzManagementServiceV1_DeleteAttestor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).DeleteAttestor(ctx, req.(*DeleteAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BinauthzManagementServiceV1_ServiceDesc is the grpc.ServiceDesc for BinauthzManagementServiceV1 service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BinauthzManagementServiceV1_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1",
	HandlerType: (*BinauthzManagementServiceV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPolicy",
			Handler:    _BinauthzManagementServiceV1_GetPolicy_Handler,
		},
		{
			MethodName: "UpdatePolicy",
			Handler:    _BinauthzManagementServiceV1_UpdatePolicy_Handler,
		},
		{
			MethodName: "CreateAttestor",
			Handler:    _BinauthzManagementServiceV1_CreateAttestor_Handler,
		},
		{
			MethodName: "GetAttestor",
			Handler:    _BinauthzManagementServiceV1_GetAttestor_Handler,
		},
		{
			MethodName: "UpdateAttestor",
			Handler:    _BinauthzManagementServiceV1_UpdateAttestor_Handler,
		},
		{
			MethodName: "ListAttestors",
			Handler:    _BinauthzManagementServiceV1_ListAttestors_Handler,
		},
		{
			MethodName: "DeleteAttestor",
			Handler:    _BinauthzManagementServiceV1_DeleteAttestor_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/binaryauthorization/v1/service.proto",
}

const (
	SystemPolicyV1_GetSystemPolicy_FullMethodName = "/google.cloud.binaryauthorization.v1.SystemPolicyV1/GetSystemPolicy"
)

// SystemPolicyV1Client is the client API for SystemPolicyV1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SystemPolicyV1Client interface {
	// Gets the current system policy in the specified location.
	GetSystemPolicy(ctx context.Context, in *GetSystemPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
}

type systemPolicyV1Client struct {
	cc grpc.ClientConnInterface
}

func NewSystemPolicyV1Client(cc grpc.ClientConnInterface) SystemPolicyV1Client {
	return &systemPolicyV1Client{cc}
}

func (c *systemPolicyV1Client) GetSystemPolicy(ctx context.Context, in *GetSystemPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, SystemPolicyV1_GetSystemPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SystemPolicyV1Server is the server API for SystemPolicyV1 service.
// All implementations should embed UnimplementedSystemPolicyV1Server
// for forward compatibility
type SystemPolicyV1Server interface {
	// Gets the current system policy in the specified location.
	GetSystemPolicy(context.Context, *GetSystemPolicyRequest) (*Policy, error)
}

// UnimplementedSystemPolicyV1Server should be embedded to have forward compatible implementations.
type UnimplementedSystemPolicyV1Server struct {
}

func (UnimplementedSystemPolicyV1Server) GetSystemPolicy(context.Context, *GetSystemPolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSystemPolicy not implemented")
}

// UnsafeSystemPolicyV1Server may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SystemPolicyV1Server will
// result in compilation errors.
type UnsafeSystemPolicyV1Server interface {
	mustEmbedUnimplementedSystemPolicyV1Server()
}

func RegisterSystemPolicyV1Server(s grpc.ServiceRegistrar, srv SystemPolicyV1Server) {
	s.RegisterService(&SystemPolicyV1_ServiceDesc, srv)
}

func _SystemPolicyV1_GetSystemPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSystemPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemPolicyV1Server).GetSystemPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemPolicyV1_GetSystemPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemPolicyV1Server).GetSystemPolicy(ctx, req.(*GetSystemPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SystemPolicyV1_ServiceDesc is the grpc.ServiceDesc for SystemPolicyV1 service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SystemPolicyV1_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.binaryauthorization.v1.SystemPolicyV1",
	HandlerType: (*SystemPolicyV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSystemPolicy",
			Handler:    _SystemPolicyV1_GetSystemPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/binaryauthorization/v1/service.proto",
}

const (
	ValidationHelperV1_ValidateAttestationOccurrence_FullMethodName = "/google.cloud.binaryauthorization.v1.ValidationHelperV1/ValidateAttestationOccurrence"
)

// ValidationHelperV1Client is the client API for ValidationHelperV1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ValidationHelperV1Client interface {
	// Returns whether the given Attestation for the given image URI
	// was signed by the given Attestor
	ValidateAttestationOccurrence(ctx context.Context, in *ValidateAttestationOccurrenceRequest, opts ...grpc.CallOption) (*ValidateAttestationOccurrenceResponse, error)
}

type validationHelperV1Client struct {
	cc grpc.ClientConnInterface
}

func NewValidationHelperV1Client(cc grpc.ClientConnInterface) ValidationHelperV1Client {
	return &validationHelperV1Client{cc}
}

func (c *validationHelperV1Client) ValidateAttestationOccurrence(ctx context.Context, in *ValidateAttestationOccurrenceRequest, opts ...grpc.CallOption) (*ValidateAttestationOccurrenceResponse, error) {
	out := new(ValidateAttestationOccurrenceResponse)
	err := c.cc.Invoke(ctx, ValidationHelperV1_ValidateAttestationOccurrence_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ValidationHelperV1Server is the server API for ValidationHelperV1 service.
// All implementations should embed UnimplementedValidationHelperV1Server
// for forward compatibility
type ValidationHelperV1Server interface {
	// Returns whether the given Attestation for the given image URI
	// was signed by the given Attestor
	ValidateAttestationOccurrence(context.Context, *ValidateAttestationOccurrenceRequest) (*ValidateAttestationOccurrenceResponse, error)
}

// UnimplementedValidationHelperV1Server should be embedded to have forward compatible implementations.
type UnimplementedValidationHelperV1Server struct {
}

func (UnimplementedValidationHelperV1Server) ValidateAttestationOccurrence(context.Context, *ValidateAttestationOccurrenceRequest) (*ValidateAttestationOccurrenceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateAttestationOccurrence not implemented")
}

// UnsafeValidationHelperV1Server may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ValidationHelperV1Server will
// result in compilation errors.
type UnsafeValidationHelperV1Server interface {
	mustEmbedUnimplementedValidationHelperV1Server()
}

func RegisterValidationHelperV1Server(s grpc.ServiceRegistrar, srv ValidationHelperV1Server) {
	s.RegisterService(&ValidationHelperV1_ServiceDesc, srv)
}

func _ValidationHelperV1_ValidateAttestationOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateAttestationOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ValidationHelperV1Server).ValidateAttestationOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ValidationHelperV1_ValidateAttestationOccurrence_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ValidationHelperV1Server).ValidateAttestationOccurrence(ctx, req.(*ValidateAttestationOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ValidationHelperV1_ServiceDesc is the grpc.ServiceDesc for ValidationHelperV1 service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ValidationHelperV1_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.binaryauthorization.v1.ValidationHelperV1",
	HandlerType: (*ValidationHelperV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ValidateAttestationOccurrence",
			Handler:    _ValidationHelperV1_ValidateAttestationOccurrence_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/binaryauthorization/v1/service.proto",
}
