// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/parameter_definition.proto

package cxpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines data types that are supported for inlined schemas. These types are
// consistent with [google.protobuf.Value][google.protobuf.Value].
type DataType int32

const (
	// Not specified.
	DataType_DATA_TYPE_UNSPECIFIED DataType = 0
	// Represents any string value.
	DataType_STRING DataType = 1
	// Represents any number value.
	DataType_NUMBER DataType = 2
	// Represents a boolean value.
	DataType_BOOLEAN DataType = 3
	// Represents a repeated value.
	DataType_ARRAY DataType = 6
)

// Enum value maps for DataType.
var (
	DataType_name = map[int32]string{
		0: "DATA_TYPE_UNSPECIFIED",
		1: "STRING",
		2: "NUMBER",
		3: "BOOLEAN",
		6: "ARRAY",
	}
	DataType_value = map[string]int32{
		"DATA_TYPE_UNSPECIFIED": 0,
		"STRING":                1,
		"NUMBER":                2,
		"BOOLEAN":               3,
		"ARRAY":                 6,
	}
)

func (x DataType) Enum() *DataType {
	p := new(DataType)
	*p = x
	return p
}

func (x DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_enumTypes[0].Descriptor()
}

func (DataType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_enumTypes[0]
}

func (x DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataType.Descriptor instead.
func (DataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescGZIP(), []int{0}
}

// Parameter types are used for validation.
// These types are consistent with
// [google.protobuf.Value][google.protobuf.Value].
type ParameterDefinition_ParameterType int32

const (
	// Not specified. No validation will be performed.
	ParameterDefinition_PARAMETER_TYPE_UNSPECIFIED ParameterDefinition_ParameterType = 0
	// Represents any string value.
	ParameterDefinition_STRING ParameterDefinition_ParameterType = 1
	// Represents any number value.
	ParameterDefinition_NUMBER ParameterDefinition_ParameterType = 2
	// Represents a boolean value.
	ParameterDefinition_BOOLEAN ParameterDefinition_ParameterType = 3
	// Represents a null value.
	ParameterDefinition_NULL ParameterDefinition_ParameterType = 4
	// Represents any object value.
	ParameterDefinition_OBJECT ParameterDefinition_ParameterType = 5
	// Represents a repeated value.
	ParameterDefinition_LIST ParameterDefinition_ParameterType = 6
)

// Enum value maps for ParameterDefinition_ParameterType.
var (
	ParameterDefinition_ParameterType_name = map[int32]string{
		0: "PARAMETER_TYPE_UNSPECIFIED",
		1: "STRING",
		2: "NUMBER",
		3: "BOOLEAN",
		4: "NULL",
		5: "OBJECT",
		6: "LIST",
	}
	ParameterDefinition_ParameterType_value = map[string]int32{
		"PARAMETER_TYPE_UNSPECIFIED": 0,
		"STRING":                     1,
		"NUMBER":                     2,
		"BOOLEAN":                    3,
		"NULL":                       4,
		"OBJECT":                     5,
		"LIST":                       6,
	}
)

func (x ParameterDefinition_ParameterType) Enum() *ParameterDefinition_ParameterType {
	p := new(ParameterDefinition_ParameterType)
	*p = x
	return p
}

func (x ParameterDefinition_ParameterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ParameterDefinition_ParameterType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_enumTypes[1].Descriptor()
}

func (ParameterDefinition_ParameterType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_enumTypes[1]
}

func (x ParameterDefinition_ParameterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ParameterDefinition_ParameterType.Descriptor instead.
func (ParameterDefinition_ParameterType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescGZIP(), []int{0, 0}
}

// Defines the properties of a parameter.
// Used to define parameters used in the agent and the
// input / output parameters for each fulfillment.
type ParameterDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of parameter.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/parameter_definition.proto.
	Type ParameterDefinition_ParameterType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.dialogflow.cx.v3beta1.ParameterDefinition_ParameterType" json:"type,omitempty"`
	// Optional. Type schema of parameter.
	TypeSchema *TypeSchema `protobuf:"bytes,4,opt,name=type_schema,json=typeSchema,proto3" json:"type_schema,omitempty"`
	// Human-readable description of the parameter. Limited to 300 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *ParameterDefinition) Reset() {
	*x = ParameterDefinition{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ParameterDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParameterDefinition) ProtoMessage() {}

func (x *ParameterDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParameterDefinition.ProtoReflect.Descriptor instead.
func (*ParameterDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescGZIP(), []int{0}
}

func (x *ParameterDefinition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/parameter_definition.proto.
func (x *ParameterDefinition) GetType() ParameterDefinition_ParameterType {
	if x != nil {
		return x.Type
	}
	return ParameterDefinition_PARAMETER_TYPE_UNSPECIFIED
}

func (x *ParameterDefinition) GetTypeSchema() *TypeSchema {
	if x != nil {
		return x.TypeSchema
	}
	return nil
}

func (x *ParameterDefinition) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Encapsulates different type schema variations: either a reference to an
// a schema that's already defined by a tool, or an inline definition.
type TypeSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encapsulated schema.
	//
	// Types that are assignable to Schema:
	//
	//	*TypeSchema_InlineSchema
	//	*TypeSchema_SchemaReference_
	Schema isTypeSchema_Schema `protobuf_oneof:"schema"`
}

func (x *TypeSchema) Reset() {
	*x = TypeSchema{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TypeSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypeSchema) ProtoMessage() {}

func (x *TypeSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypeSchema.ProtoReflect.Descriptor instead.
func (*TypeSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescGZIP(), []int{1}
}

func (m *TypeSchema) GetSchema() isTypeSchema_Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (x *TypeSchema) GetInlineSchema() *InlineSchema {
	if x, ok := x.GetSchema().(*TypeSchema_InlineSchema); ok {
		return x.InlineSchema
	}
	return nil
}

func (x *TypeSchema) GetSchemaReference() *TypeSchema_SchemaReference {
	if x, ok := x.GetSchema().(*TypeSchema_SchemaReference_); ok {
		return x.SchemaReference
	}
	return nil
}

type isTypeSchema_Schema interface {
	isTypeSchema_Schema()
}

type TypeSchema_InlineSchema struct {
	// Set if this is an inline schema definition.
	InlineSchema *InlineSchema `protobuf:"bytes,1,opt,name=inline_schema,json=inlineSchema,proto3,oneof"`
}

type TypeSchema_SchemaReference_ struct {
	// Set if this is a schema reference.
	SchemaReference *TypeSchema_SchemaReference `protobuf:"bytes,2,opt,name=schema_reference,json=schemaReference,proto3,oneof"`
}

func (*TypeSchema_InlineSchema) isTypeSchema_Schema() {}

func (*TypeSchema_SchemaReference_) isTypeSchema_Schema() {}

// A type schema object that's specified inline.
type InlineSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data type of the schema.
	Type DataType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.dialogflow.cx.v3beta1.DataType" json:"type,omitempty"`
	// Schema of the elements if this is an ARRAY type.
	Items *TypeSchema `protobuf:"bytes,2,opt,name=items,proto3" json:"items,omitempty"`
}

func (x *InlineSchema) Reset() {
	*x = InlineSchema{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InlineSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InlineSchema) ProtoMessage() {}

func (x *InlineSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InlineSchema.ProtoReflect.Descriptor instead.
func (*InlineSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescGZIP(), []int{2}
}

func (x *InlineSchema) GetType() DataType {
	if x != nil {
		return x.Type
	}
	return DataType_DATA_TYPE_UNSPECIFIED
}

func (x *InlineSchema) GetItems() *TypeSchema {
	if x != nil {
		return x.Items
	}
	return nil
}

// A reference to the schema of an existing tool.
type TypeSchema_SchemaReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The tool that contains this schema definition.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>`.
	Tool string `protobuf:"bytes,1,opt,name=tool,proto3" json:"tool,omitempty"`
	// The name of the schema.
	Schema string `protobuf:"bytes,2,opt,name=schema,proto3" json:"schema,omitempty"`
}

func (x *TypeSchema_SchemaReference) Reset() {
	*x = TypeSchema_SchemaReference{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TypeSchema_SchemaReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypeSchema_SchemaReference) ProtoMessage() {}

func (x *TypeSchema_SchemaReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypeSchema_SchemaReference.ProtoReflect.Descriptor instead.
func (*TypeSchema_SchemaReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescGZIP(), []int{1, 0}
}

func (x *TypeSchema_SchemaReference) GetTool() string {
	if x != nil {
		return x.Tool
	}
	return ""
}

func (x *TypeSchema_SchemaReference) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

var File_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x64,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfb, 0x02, 0x0a, 0x13, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x54, 0x0a, 0x0b, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x74, 0x79, 0x70, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0x0a, 0x0d,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a,
	0x1a, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x55, 0x4d,
	0x42, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e,
	0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06,
	0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x05, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x49, 0x53, 0x54,
	0x10, 0x06, 0x22, 0x9b, 0x02, 0x0a, 0x0a, 0x54, 0x79, 0x70, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x57, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x6b, 0x0a, 0x10, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x3d, 0x0a, 0x0f, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x6f,
	0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x22, 0x96, 0x01, 0x0a, 0x0c, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x2a, 0x55, 0x0a, 0x08, 0x44, 0x61, 0x74,
	0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c,
	0x45, 0x41, 0x4e, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x52, 0x52, 0x41, 0x59, 0x10, 0x06,
	0x42, 0x7c, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x18, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_goTypes = []any{
	(DataType)(0),                          // 0: google.cloud.dialogflow.cx.v3beta1.DataType
	(ParameterDefinition_ParameterType)(0), // 1: google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.ParameterType
	(*ParameterDefinition)(nil),            // 2: google.cloud.dialogflow.cx.v3beta1.ParameterDefinition
	(*TypeSchema)(nil),                     // 3: google.cloud.dialogflow.cx.v3beta1.TypeSchema
	(*InlineSchema)(nil),                   // 4: google.cloud.dialogflow.cx.v3beta1.InlineSchema
	(*TypeSchema_SchemaReference)(nil),     // 5: google.cloud.dialogflow.cx.v3beta1.TypeSchema.SchemaReference
}
var file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_depIdxs = []int32{
	1, // 0: google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.type:type_name -> google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.ParameterType
	3, // 1: google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.type_schema:type_name -> google.cloud.dialogflow.cx.v3beta1.TypeSchema
	4, // 2: google.cloud.dialogflow.cx.v3beta1.TypeSchema.inline_schema:type_name -> google.cloud.dialogflow.cx.v3beta1.InlineSchema
	5, // 3: google.cloud.dialogflow.cx.v3beta1.TypeSchema.schema_reference:type_name -> google.cloud.dialogflow.cx.v3beta1.TypeSchema.SchemaReference
	0, // 4: google.cloud.dialogflow.cx.v3beta1.InlineSchema.type:type_name -> google.cloud.dialogflow.cx.v3beta1.DataType
	3, // 5: google.cloud.dialogflow.cx.v3beta1.InlineSchema.items:type_name -> google.cloud.dialogflow.cx.v3beta1.TypeSchema
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes[1].OneofWrappers = []any{
		(*TypeSchema_InlineSchema)(nil),
		(*TypeSchema_SchemaReference_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_depIdxs = nil
}
