// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/gkemulticloud/v1/aws_service.proto

package gkemulticloudpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AwsClusters_CreateAwsCluster_FullMethodName             = "/google.cloud.gkemulticloud.v1.AwsClusters/CreateAwsCluster"
	AwsClusters_UpdateAwsCluster_FullMethodName             = "/google.cloud.gkemulticloud.v1.AwsClusters/UpdateAwsCluster"
	AwsClusters_GetAwsCluster_FullMethodName                = "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsCluster"
	AwsClusters_ListAwsClusters_FullMethodName              = "/google.cloud.gkemulticloud.v1.AwsClusters/ListAwsClusters"
	AwsClusters_DeleteAwsCluster_FullMethodName             = "/google.cloud.gkemulticloud.v1.AwsClusters/DeleteAwsCluster"
	AwsClusters_GenerateAwsClusterAgentToken_FullMethodName = "/google.cloud.gkemulticloud.v1.AwsClusters/GenerateAwsClusterAgentToken"
	AwsClusters_GenerateAwsAccessToken_FullMethodName       = "/google.cloud.gkemulticloud.v1.AwsClusters/GenerateAwsAccessToken"
	AwsClusters_CreateAwsNodePool_FullMethodName            = "/google.cloud.gkemulticloud.v1.AwsClusters/CreateAwsNodePool"
	AwsClusters_UpdateAwsNodePool_FullMethodName            = "/google.cloud.gkemulticloud.v1.AwsClusters/UpdateAwsNodePool"
	AwsClusters_RollbackAwsNodePoolUpdate_FullMethodName    = "/google.cloud.gkemulticloud.v1.AwsClusters/RollbackAwsNodePoolUpdate"
	AwsClusters_GetAwsNodePool_FullMethodName               = "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsNodePool"
	AwsClusters_ListAwsNodePools_FullMethodName             = "/google.cloud.gkemulticloud.v1.AwsClusters/ListAwsNodePools"
	AwsClusters_DeleteAwsNodePool_FullMethodName            = "/google.cloud.gkemulticloud.v1.AwsClusters/DeleteAwsNodePool"
	AwsClusters_GetAwsOpenIdConfig_FullMethodName           = "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsOpenIdConfig"
	AwsClusters_GetAwsJsonWebKeys_FullMethodName            = "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsJsonWebKeys"
	AwsClusters_GetAwsServerConfig_FullMethodName           = "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsServerConfig"
)

// AwsClustersClient is the client API for AwsClusters service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AwsClustersClient interface {
	// Creates a new [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource on a given Google Cloud Platform project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAwsCluster(ctx context.Context, in *CreateAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	UpdateAwsCluster(ctx context.Context, in *UpdateAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Describes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource.
	GetAwsCluster(ctx context.Context, in *GetAwsClusterRequest, opts ...grpc.CallOption) (*AwsCluster, error)
	// Lists all [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources
	// on a given Google Cloud project and region.
	ListAwsClusters(ctx context.Context, in *ListAwsClustersRequest, opts ...grpc.CallOption) (*ListAwsClustersResponse, error)
	// Deletes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource.
	//
	// Fails if the cluster has one or more associated
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resources.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAwsCluster(ctx context.Context, in *DeleteAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Generates an access token for a cluster agent.
	GenerateAwsClusterAgentToken(ctx context.Context, in *GenerateAwsClusterAgentTokenRequest, opts ...grpc.CallOption) (*GenerateAwsClusterAgentTokenResponse, error)
	// Generates a short-lived access token to authenticate to a given
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource.
	GenerateAwsAccessToken(ctx context.Context, in *GenerateAwsAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAwsAccessTokenResponse, error)
	// Creates a new [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool],
	// attached to a given [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAwsNodePool(ctx context.Context, in *CreateAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool].
	UpdateAwsNodePool(ctx context.Context, in *UpdateAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Rolls back a previously aborted or failed
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] update request.
	// Makes no changes if the last update request successfully finished.
	// If an update request is in progress, you cannot rollback the update.
	// You must first cancel or let it finish unsuccessfully before you can
	// rollback.
	RollbackAwsNodePoolUpdate(ctx context.Context, in *RollbackAwsNodePoolUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Describes a specific
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource.
	GetAwsNodePool(ctx context.Context, in *GetAwsNodePoolRequest, opts ...grpc.CallOption) (*AwsNodePool, error)
	// Lists all [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
	// resources on a given
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	ListAwsNodePools(ctx context.Context, in *ListAwsNodePoolsRequest, opts ...grpc.CallOption) (*ListAwsNodePoolsResponse, error)
	// Deletes a specific [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
	// resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAwsNodePool(ctx context.Context, in *DeleteAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the OIDC discovery document for the cluster.
	// See the
	// [OpenID Connect Discovery 1.0
	// specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
	// for details.
	GetAwsOpenIdConfig(ctx context.Context, in *GetAwsOpenIdConfigRequest, opts ...grpc.CallOption) (*AwsOpenIdConfig, error)
	// Gets the public component of the cluster signing keys in
	// JSON Web Key format.
	GetAwsJsonWebKeys(ctx context.Context, in *GetAwsJsonWebKeysRequest, opts ...grpc.CallOption) (*AwsJsonWebKeys, error)
	// Returns information, such as supported AWS regions and Kubernetes
	// versions, on a given Google Cloud location.
	GetAwsServerConfig(ctx context.Context, in *GetAwsServerConfigRequest, opts ...grpc.CallOption) (*AwsServerConfig, error)
}

type awsClustersClient struct {
	cc grpc.ClientConnInterface
}

func NewAwsClustersClient(cc grpc.ClientConnInterface) AwsClustersClient {
	return &awsClustersClient{cc}
}

func (c *awsClustersClient) CreateAwsCluster(ctx context.Context, in *CreateAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AwsClusters_CreateAwsCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) UpdateAwsCluster(ctx context.Context, in *UpdateAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AwsClusters_UpdateAwsCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GetAwsCluster(ctx context.Context, in *GetAwsClusterRequest, opts ...grpc.CallOption) (*AwsCluster, error) {
	out := new(AwsCluster)
	err := c.cc.Invoke(ctx, AwsClusters_GetAwsCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) ListAwsClusters(ctx context.Context, in *ListAwsClustersRequest, opts ...grpc.CallOption) (*ListAwsClustersResponse, error) {
	out := new(ListAwsClustersResponse)
	err := c.cc.Invoke(ctx, AwsClusters_ListAwsClusters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) DeleteAwsCluster(ctx context.Context, in *DeleteAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AwsClusters_DeleteAwsCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GenerateAwsClusterAgentToken(ctx context.Context, in *GenerateAwsClusterAgentTokenRequest, opts ...grpc.CallOption) (*GenerateAwsClusterAgentTokenResponse, error) {
	out := new(GenerateAwsClusterAgentTokenResponse)
	err := c.cc.Invoke(ctx, AwsClusters_GenerateAwsClusterAgentToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GenerateAwsAccessToken(ctx context.Context, in *GenerateAwsAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAwsAccessTokenResponse, error) {
	out := new(GenerateAwsAccessTokenResponse)
	err := c.cc.Invoke(ctx, AwsClusters_GenerateAwsAccessToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) CreateAwsNodePool(ctx context.Context, in *CreateAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AwsClusters_CreateAwsNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) UpdateAwsNodePool(ctx context.Context, in *UpdateAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AwsClusters_UpdateAwsNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) RollbackAwsNodePoolUpdate(ctx context.Context, in *RollbackAwsNodePoolUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AwsClusters_RollbackAwsNodePoolUpdate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GetAwsNodePool(ctx context.Context, in *GetAwsNodePoolRequest, opts ...grpc.CallOption) (*AwsNodePool, error) {
	out := new(AwsNodePool)
	err := c.cc.Invoke(ctx, AwsClusters_GetAwsNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) ListAwsNodePools(ctx context.Context, in *ListAwsNodePoolsRequest, opts ...grpc.CallOption) (*ListAwsNodePoolsResponse, error) {
	out := new(ListAwsNodePoolsResponse)
	err := c.cc.Invoke(ctx, AwsClusters_ListAwsNodePools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) DeleteAwsNodePool(ctx context.Context, in *DeleteAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AwsClusters_DeleteAwsNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GetAwsOpenIdConfig(ctx context.Context, in *GetAwsOpenIdConfigRequest, opts ...grpc.CallOption) (*AwsOpenIdConfig, error) {
	out := new(AwsOpenIdConfig)
	err := c.cc.Invoke(ctx, AwsClusters_GetAwsOpenIdConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GetAwsJsonWebKeys(ctx context.Context, in *GetAwsJsonWebKeysRequest, opts ...grpc.CallOption) (*AwsJsonWebKeys, error) {
	out := new(AwsJsonWebKeys)
	err := c.cc.Invoke(ctx, AwsClusters_GetAwsJsonWebKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GetAwsServerConfig(ctx context.Context, in *GetAwsServerConfigRequest, opts ...grpc.CallOption) (*AwsServerConfig, error) {
	out := new(AwsServerConfig)
	err := c.cc.Invoke(ctx, AwsClusters_GetAwsServerConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AwsClustersServer is the server API for AwsClusters service.
// All implementations should embed UnimplementedAwsClustersServer
// for forward compatibility
type AwsClustersServer interface {
	// Creates a new [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource on a given Google Cloud Platform project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAwsCluster(context.Context, *CreateAwsClusterRequest) (*longrunningpb.Operation, error)
	// Updates an [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	UpdateAwsCluster(context.Context, *UpdateAwsClusterRequest) (*longrunningpb.Operation, error)
	// Describes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource.
	GetAwsCluster(context.Context, *GetAwsClusterRequest) (*AwsCluster, error)
	// Lists all [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources
	// on a given Google Cloud project and region.
	ListAwsClusters(context.Context, *ListAwsClustersRequest) (*ListAwsClustersResponse, error)
	// Deletes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource.
	//
	// Fails if the cluster has one or more associated
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resources.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAwsCluster(context.Context, *DeleteAwsClusterRequest) (*longrunningpb.Operation, error)
	// Generates an access token for a cluster agent.
	GenerateAwsClusterAgentToken(context.Context, *GenerateAwsClusterAgentTokenRequest) (*GenerateAwsClusterAgentTokenResponse, error)
	// Generates a short-lived access token to authenticate to a given
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource.
	GenerateAwsAccessToken(context.Context, *GenerateAwsAccessTokenRequest) (*GenerateAwsAccessTokenResponse, error)
	// Creates a new [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool],
	// attached to a given [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAwsNodePool(context.Context, *CreateAwsNodePoolRequest) (*longrunningpb.Operation, error)
	// Updates an [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool].
	UpdateAwsNodePool(context.Context, *UpdateAwsNodePoolRequest) (*longrunningpb.Operation, error)
	// Rolls back a previously aborted or failed
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] update request.
	// Makes no changes if the last update request successfully finished.
	// If an update request is in progress, you cannot rollback the update.
	// You must first cancel or let it finish unsuccessfully before you can
	// rollback.
	RollbackAwsNodePoolUpdate(context.Context, *RollbackAwsNodePoolUpdateRequest) (*longrunningpb.Operation, error)
	// Describes a specific
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource.
	GetAwsNodePool(context.Context, *GetAwsNodePoolRequest) (*AwsNodePool, error)
	// Lists all [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
	// resources on a given
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	ListAwsNodePools(context.Context, *ListAwsNodePoolsRequest) (*ListAwsNodePoolsResponse, error)
	// Deletes a specific [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
	// resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAwsNodePool(context.Context, *DeleteAwsNodePoolRequest) (*longrunningpb.Operation, error)
	// Gets the OIDC discovery document for the cluster.
	// See the
	// [OpenID Connect Discovery 1.0
	// specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
	// for details.
	GetAwsOpenIdConfig(context.Context, *GetAwsOpenIdConfigRequest) (*AwsOpenIdConfig, error)
	// Gets the public component of the cluster signing keys in
	// JSON Web Key format.
	GetAwsJsonWebKeys(context.Context, *GetAwsJsonWebKeysRequest) (*AwsJsonWebKeys, error)
	// Returns information, such as supported AWS regions and Kubernetes
	// versions, on a given Google Cloud location.
	GetAwsServerConfig(context.Context, *GetAwsServerConfigRequest) (*AwsServerConfig, error)
}

// UnimplementedAwsClustersServer should be embedded to have forward compatible implementations.
type UnimplementedAwsClustersServer struct {
}

func (UnimplementedAwsClustersServer) CreateAwsCluster(context.Context, *CreateAwsClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAwsCluster not implemented")
}
func (UnimplementedAwsClustersServer) UpdateAwsCluster(context.Context, *UpdateAwsClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAwsCluster not implemented")
}
func (UnimplementedAwsClustersServer) GetAwsCluster(context.Context, *GetAwsClusterRequest) (*AwsCluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAwsCluster not implemented")
}
func (UnimplementedAwsClustersServer) ListAwsClusters(context.Context, *ListAwsClustersRequest) (*ListAwsClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAwsClusters not implemented")
}
func (UnimplementedAwsClustersServer) DeleteAwsCluster(context.Context, *DeleteAwsClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAwsCluster not implemented")
}
func (UnimplementedAwsClustersServer) GenerateAwsClusterAgentToken(context.Context, *GenerateAwsClusterAgentTokenRequest) (*GenerateAwsClusterAgentTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAwsClusterAgentToken not implemented")
}
func (UnimplementedAwsClustersServer) GenerateAwsAccessToken(context.Context, *GenerateAwsAccessTokenRequest) (*GenerateAwsAccessTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAwsAccessToken not implemented")
}
func (UnimplementedAwsClustersServer) CreateAwsNodePool(context.Context, *CreateAwsNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAwsNodePool not implemented")
}
func (UnimplementedAwsClustersServer) UpdateAwsNodePool(context.Context, *UpdateAwsNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAwsNodePool not implemented")
}
func (UnimplementedAwsClustersServer) RollbackAwsNodePoolUpdate(context.Context, *RollbackAwsNodePoolUpdateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackAwsNodePoolUpdate not implemented")
}
func (UnimplementedAwsClustersServer) GetAwsNodePool(context.Context, *GetAwsNodePoolRequest) (*AwsNodePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAwsNodePool not implemented")
}
func (UnimplementedAwsClustersServer) ListAwsNodePools(context.Context, *ListAwsNodePoolsRequest) (*ListAwsNodePoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAwsNodePools not implemented")
}
func (UnimplementedAwsClustersServer) DeleteAwsNodePool(context.Context, *DeleteAwsNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAwsNodePool not implemented")
}
func (UnimplementedAwsClustersServer) GetAwsOpenIdConfig(context.Context, *GetAwsOpenIdConfigRequest) (*AwsOpenIdConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAwsOpenIdConfig not implemented")
}
func (UnimplementedAwsClustersServer) GetAwsJsonWebKeys(context.Context, *GetAwsJsonWebKeysRequest) (*AwsJsonWebKeys, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAwsJsonWebKeys not implemented")
}
func (UnimplementedAwsClustersServer) GetAwsServerConfig(context.Context, *GetAwsServerConfigRequest) (*AwsServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAwsServerConfig not implemented")
}

// UnsafeAwsClustersServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AwsClustersServer will
// result in compilation errors.
type UnsafeAwsClustersServer interface {
	mustEmbedUnimplementedAwsClustersServer()
}

func RegisterAwsClustersServer(s grpc.ServiceRegistrar, srv AwsClustersServer) {
	s.RegisterService(&AwsClusters_ServiceDesc, srv)
}

func _AwsClusters_CreateAwsCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAwsClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).CreateAwsCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_CreateAwsCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).CreateAwsCluster(ctx, req.(*CreateAwsClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_UpdateAwsCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAwsClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).UpdateAwsCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_UpdateAwsCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).UpdateAwsCluster(ctx, req.(*UpdateAwsClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GetAwsCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAwsClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GetAwsCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_GetAwsCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GetAwsCluster(ctx, req.(*GetAwsClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_ListAwsClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAwsClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).ListAwsClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_ListAwsClusters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).ListAwsClusters(ctx, req.(*ListAwsClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_DeleteAwsCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAwsClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).DeleteAwsCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_DeleteAwsCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).DeleteAwsCluster(ctx, req.(*DeleteAwsClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GenerateAwsClusterAgentToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAwsClusterAgentTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GenerateAwsClusterAgentToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_GenerateAwsClusterAgentToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GenerateAwsClusterAgentToken(ctx, req.(*GenerateAwsClusterAgentTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GenerateAwsAccessToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAwsAccessTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GenerateAwsAccessToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_GenerateAwsAccessToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GenerateAwsAccessToken(ctx, req.(*GenerateAwsAccessTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_CreateAwsNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAwsNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).CreateAwsNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_CreateAwsNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).CreateAwsNodePool(ctx, req.(*CreateAwsNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_UpdateAwsNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAwsNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).UpdateAwsNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_UpdateAwsNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).UpdateAwsNodePool(ctx, req.(*UpdateAwsNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_RollbackAwsNodePoolUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackAwsNodePoolUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).RollbackAwsNodePoolUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_RollbackAwsNodePoolUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).RollbackAwsNodePoolUpdate(ctx, req.(*RollbackAwsNodePoolUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GetAwsNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAwsNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GetAwsNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_GetAwsNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GetAwsNodePool(ctx, req.(*GetAwsNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_ListAwsNodePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAwsNodePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).ListAwsNodePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_ListAwsNodePools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).ListAwsNodePools(ctx, req.(*ListAwsNodePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_DeleteAwsNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAwsNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).DeleteAwsNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_DeleteAwsNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).DeleteAwsNodePool(ctx, req.(*DeleteAwsNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GetAwsOpenIdConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAwsOpenIdConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GetAwsOpenIdConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_GetAwsOpenIdConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GetAwsOpenIdConfig(ctx, req.(*GetAwsOpenIdConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GetAwsJsonWebKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAwsJsonWebKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GetAwsJsonWebKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_GetAwsJsonWebKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GetAwsJsonWebKeys(ctx, req.(*GetAwsJsonWebKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GetAwsServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAwsServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GetAwsServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AwsClusters_GetAwsServerConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GetAwsServerConfig(ctx, req.(*GetAwsServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AwsClusters_ServiceDesc is the grpc.ServiceDesc for AwsClusters service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AwsClusters_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkemulticloud.v1.AwsClusters",
	HandlerType: (*AwsClustersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAwsCluster",
			Handler:    _AwsClusters_CreateAwsCluster_Handler,
		},
		{
			MethodName: "UpdateAwsCluster",
			Handler:    _AwsClusters_UpdateAwsCluster_Handler,
		},
		{
			MethodName: "GetAwsCluster",
			Handler:    _AwsClusters_GetAwsCluster_Handler,
		},
		{
			MethodName: "ListAwsClusters",
			Handler:    _AwsClusters_ListAwsClusters_Handler,
		},
		{
			MethodName: "DeleteAwsCluster",
			Handler:    _AwsClusters_DeleteAwsCluster_Handler,
		},
		{
			MethodName: "GenerateAwsClusterAgentToken",
			Handler:    _AwsClusters_GenerateAwsClusterAgentToken_Handler,
		},
		{
			MethodName: "GenerateAwsAccessToken",
			Handler:    _AwsClusters_GenerateAwsAccessToken_Handler,
		},
		{
			MethodName: "CreateAwsNodePool",
			Handler:    _AwsClusters_CreateAwsNodePool_Handler,
		},
		{
			MethodName: "UpdateAwsNodePool",
			Handler:    _AwsClusters_UpdateAwsNodePool_Handler,
		},
		{
			MethodName: "RollbackAwsNodePoolUpdate",
			Handler:    _AwsClusters_RollbackAwsNodePoolUpdate_Handler,
		},
		{
			MethodName: "GetAwsNodePool",
			Handler:    _AwsClusters_GetAwsNodePool_Handler,
		},
		{
			MethodName: "ListAwsNodePools",
			Handler:    _AwsClusters_ListAwsNodePools_Handler,
		},
		{
			MethodName: "DeleteAwsNodePool",
			Handler:    _AwsClusters_DeleteAwsNodePool_Handler,
		},
		{
			MethodName: "GetAwsOpenIdConfig",
			Handler:    _AwsClusters_GetAwsOpenIdConfig_Handler,
		},
		{
			MethodName: "GetAwsJsonWebKeys",
			Handler:    _AwsClusters_GetAwsJsonWebKeys_Handler,
		},
		{
			MethodName: "GetAwsServerConfig",
			Handler:    _AwsClusters_GetAwsServerConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkemulticloud/v1/aws_service.proto",
}
