/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

final class Context<T> {
    private final T _default;
    private final AtomicReference<Entry<T>> _entry;
    private final ThreadLocal<Entry<T>> _threadLocalEntry = new ThreadLocal();

    Context(T defaultValue) {
        this._default = defaultValue;
        this._entry = new AtomicReference<Entry<T>>(new Entry<T>(defaultValue));
    }

    void set(T value) {
        Entry<T> e = this._threadLocalEntry.get();
        if (e != null) {
            e.value = value;
        } else {
            this._entry.set(new Entry<T>(value));
        }
    }

    T get() {
        Entry<T> e;
        return ((e = this._threadLocalEntry.get()) != null ? e : this._entry.get()).value;
    }

    void reset() {
        this.set(this._default);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <S extends T, R> R with(S value, Function<S, R> f) {
        Entry<S> e = this._threadLocalEntry.get();
        if (e != null) {
            this._threadLocalEntry.set(e.inner(value));
        } else {
            this._threadLocalEntry.set(new Entry<S>(value, Thread.currentThread()));
        }
        try {
            R r = f.apply(value);
            return r;
        }
        finally {
            this._threadLocalEntry.set(this._threadLocalEntry.get().parent);
        }
    }

    private static final class Entry<T> {
        final Thread thread;
        final Entry<T> parent;
        T value;

        Entry(T value, Entry<T> parent, Thread thread) {
            this.value = value;
            this.parent = parent;
            this.thread = thread;
        }

        Entry(T value, Thread thread) {
            this(value, null, thread);
        }

        Entry(T value) {
            this(value, null, null);
        }

        Entry<T> inner(T value) {
            assert (this.thread == Thread.currentThread());
            return new Entry<T>(value, this, this.thread);
        }
    }
}

