/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.collection;

import io.jenetics.internal.collection.Array;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class ArrayIterator<T>
implements ListIterator<T> {
    public final Array<T> array;
    protected int cursor = 0;
    protected int lastElement = -1;

    public ArrayIterator(Array<T> array2) {
        this.array = Objects.requireNonNull(array2, "Array must not be null.");
    }

    @Override
    public boolean hasNext() {
        return this.cursor != this.array.length();
    }

    @Override
    public T next() {
        int i = this.cursor;
        if (this.cursor >= this.array.length()) {
            throw new NoSuchElementException();
        }
        this.cursor = i + 1;
        this.lastElement = i;
        return this.array.get(this.lastElement);
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor != 0;
    }

    @Override
    public T previous() {
        int i = this.cursor - 1;
        if (i < 0) {
            throw new NoSuchElementException();
        }
        this.cursor = i;
        this.lastElement = i;
        return this.array.get(this.lastElement);
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public void set(T value) {
        throw new UnsupportedOperationException("Iterator is immutable.");
    }

    @Override
    public void add(T value) {
        throw new UnsupportedOperationException("Can't change Iterator size.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't change Iterator size.");
    }
}

