/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.firewallzone;

import com.ubnt.F.E;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeKey;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeSection;
import com.ubnt.service.config.L;
import com.ubnt.service.firewallzone.D;
import com.ubnt.service.systemlog.admin.activity.changes.N;
import com.ubnt.service.systemlog.admin.activity.changes.Q;
import com.ubnt.service.systemlog.admin.activity.changes.o0Oo;
import com.ubnt.service.systemlog.admin.activity.changes.public;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.immutables.builder.Builder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Immutable;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Immutable
@Document(collection="firewall_zone")
@E
public class FirewallZoneDocument
implements com.ubnt.repository.Object,
L,
o0Oo {
    public static final String COLLECTION_NAME = "firewall_zone";
    private static final Set<String> CHANGELOG_IGNORED_PROPERTIES = Set.of("attr_no_edit", "external_id", "default_zone");
    @Id
    private String id;
    @Field(value="external_id")
    private UUID externalId;
    @Field(value="site_id")
    @Indexed
    private final String siteId;
    @Field(value="name")
    private final String name;
    @Field(value="zone_key")
    private final String zoneKey;
    @Field(value="default_zone")
    private final boolean defaultZone;
    @Field(value="attr_no_edit")
    private final boolean noEdit;

    @Builder.Constructor
    public FirewallZoneDocument(@Value(value="_id") @Nullable String string, @Value(value="external_id") @Nullable UUID uUID, @Value(value="site_id") String string2, @Value(value="name") String string3, @Value(value="zone_key") @Nullable String string4, @Value(value="default_zone") boolean bl, @Value(value="attr_no_edit") boolean bl2) {
        this.id = string;
        this.externalId = uUID;
        this.siteId = string2;
        this.name = string3;
        this.zoneKey = string4;
        this.defaultZone = bl;
        this.noEdit = bl2;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public UUID getExternalId() {
        return this.externalId;
    }

    @Override
    public AdminChangeSection getSection() {
        return AdminChangeSection.FIREWALL_ZONE;
    }

    @Override
    public AdminChangeKey getChangeKey() {
        return AdminChangeKey.SECURITY;
    }

    @Override
    public Optional<public> getDepiction() {
        return public.String("name", this.getName());
    }

    @Override
    public Q getChangeLogRule(N n2) {
        return this.defaultZone ? Q.\u00d200000 : Q.\u00d300000().o00000(CHANGELOG_IGNORED_PROPERTIES).\u00d500000();
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getZoneKey() {
        return Optional.ofNullable(this.zoneKey);
    }

    public boolean isDefaultZone() {
        return this.defaultZone;
    }

    public boolean isNoEdit() {
        return this.noEdit;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FirewallZoneDocument firewallZoneDocument = (FirewallZoneDocument)object;
        return new EqualsBuilder().append((Object)this.id, (Object)firewallZoneDocument.id).append((Object)this.externalId, (Object)firewallZoneDocument.externalId).append((Object)this.siteId, (Object)firewallZoneDocument.siteId).append((Object)this.name, (Object)firewallZoneDocument.name).append((Object)this.zoneKey, (Object)firewallZoneDocument.zoneKey).append(this.defaultZone, firewallZoneDocument.defaultZone).append(this.noEdit, firewallZoneDocument.noEdit).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.externalId).append((Object)this.siteId).append((Object)this.name).append((Object)this.zoneKey).append(this.defaultZone).append(this.noEdit).toHashCode();
    }

    @Override
    public String getCollectionName() {
        return COLLECTION_NAME;
    }

    public static D builder() {
        return new D();
    }

    public static class _o {
        public static final String new = "external_id";
        public static final String \u00d300000 = "name";
        public static final String o00000 = "zone_key";
        static final String \u00d400000 = "default_zone";

        private _o() {
        }
    }
}

