/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.api.network.dto.details;

import com.ubnt.net.Dto;
import com.ubnt.net.integration.api.network.dto.details.IntegrationNetworkIpv4DhcpConfigurationDto;
import com.ubnt.net.v2.validation.constraints.Ip;
import com.ubnt.net.v2.validation.constraints.IpCidr;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class IntegrationNetworkIpv4ConfigurationDto<T extends IntegrationNetworkIpv4DhcpConfigurationDto>
implements Dto {
    @NotNull
    @Schema(description="Whether the Network can automatically scale its subnet size based on the number of active DHCP leases.")
    private final Boolean autoScaleEnabled;
    @NotNull
    @Ip
    private final String hostIpAddress;
    @NotNull
    @Min(value=8L)
    @Max(value=30L)
    private final @NotNull @Min(value=8L) @Max(value=30L) Integer prefixLength;
    @Nullable
    @Size(min=1, max=64)
    @ArraySchema(minItems=1, maxItems=64)
    @Schema(description="Additional host IP subnets assigned to this VLAN.")
    private final @Size(min=1, max=64) List<@NotNull @IpCidr String> additionalHostIpSubnets;
    @Valid
    @Nullable
    @Schema(description="IPv4 DHCP configuration for this network. If this field is omitted or null, DHCP is not working and hosts must get an address statically or from another server in this broadcast domain.")
    private final T dhcpConfiguration;

    @Generated
    protected IntegrationNetworkIpv4ConfigurationDto(IntegrationNetworkIpv4ConfigurationDtoBuilder<T, ?, ?> integrationNetworkIpv4ConfigurationDtoBuilder) {
        this.autoScaleEnabled = integrationNetworkIpv4ConfigurationDtoBuilder.\u00d500000;
        this.hostIpAddress = integrationNetworkIpv4ConfigurationDtoBuilder.o00000;
        this.prefixLength = integrationNetworkIpv4ConfigurationDtoBuilder.\u00d200000;
        this.additionalHostIpSubnets = integrationNetworkIpv4ConfigurationDtoBuilder.\u00d300000;
        this.dhcpConfiguration = integrationNetworkIpv4ConfigurationDtoBuilder.String;
    }

    @Generated
    public Boolean getAutoScaleEnabled() {
        return this.autoScaleEnabled;
    }

    @Generated
    public String getHostIpAddress() {
        return this.hostIpAddress;
    }

    @Generated
    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    @Nullable
    @Generated
    public List<@NotNull @IpCidr String> getAdditionalHostIpSubnets() {
        return this.additionalHostIpSubnets;
    }

    @Nullable
    @Generated
    public T getDhcpConfiguration() {
        return this.dhcpConfiguration;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationNetworkIpv4ConfigurationDto)) {
            return false;
        }
        IntegrationNetworkIpv4ConfigurationDto integrationNetworkIpv4ConfigurationDto = (IntegrationNetworkIpv4ConfigurationDto)object;
        if (!integrationNetworkIpv4ConfigurationDto.canEqual(this)) {
            return false;
        }
        Boolean bl = this.getAutoScaleEnabled();
        Boolean bl2 = integrationNetworkIpv4ConfigurationDto.getAutoScaleEnabled();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        Integer n2 = this.getPrefixLength();
        Integer n3 = integrationNetworkIpv4ConfigurationDto.getPrefixLength();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        String string = this.getHostIpAddress();
        String string2 = integrationNetworkIpv4ConfigurationDto.getHostIpAddress();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        List<String> list = this.getAdditionalHostIpSubnets();
        List<String> list2 = integrationNetworkIpv4ConfigurationDto.getAdditionalHostIpSubnets();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        T t2 = this.getDhcpConfiguration();
        T t3 = integrationNetworkIpv4ConfigurationDto.getDhcpConfiguration();
        return !(t2 == null ? t3 != null : !t2.equals(t3));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof IntegrationNetworkIpv4ConfigurationDto;
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        Boolean bl = this.getAutoScaleEnabled();
        n2 = n2 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        Integer n3 = this.getPrefixLength();
        n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        String string = this.getHostIpAddress();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        List<String> list = this.getAdditionalHostIpSubnets();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        T t2 = this.getDhcpConfiguration();
        n2 = n2 * 59 + (t2 == null ? 43 : t2.hashCode());
        return n2;
    }

    @Generated
    public static abstract class IntegrationNetworkIpv4ConfigurationDtoBuilder<T extends IntegrationNetworkIpv4DhcpConfigurationDto, C extends IntegrationNetworkIpv4ConfigurationDto<T>, B extends IntegrationNetworkIpv4ConfigurationDtoBuilder<T, C, B>> {
        @Generated
        private Boolean \u00d500000;
        @Generated
        private String o00000;
        @Generated
        private Integer \u00d200000;
        @Generated
        private List<@NotNull @IpCidr String> \u00d300000;
        @Generated
        private T String;

        @Generated
        public B autoScaleEnabled(Boolean bl) {
            this.\u00d500000 = bl;
            return this.o00000();
        }

        @Generated
        public B hostIpAddress(String string) {
            this.o00000 = string;
            return this.o00000();
        }

        @Generated
        public B prefixLength(Integer n2) {
            this.\u00d200000 = n2;
            return this.o00000();
        }

        @Generated
        public B additionalHostIpSubnets(@Nullable List<@NotNull @IpCidr String> list) {
            this.\u00d300000 = list;
            return this.o00000();
        }

        @Generated
        public B dhcpConfiguration(@Nullable T t2) {
            this.String = t2;
            return this.o00000();
        }

        @Generated
        protected abstract B o00000();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IntegrationNetworkIpv4ConfigurationDto.IntegrationNetworkIpv4ConfigurationDtoBuilder(autoScaleEnabled=" + this.\u00d500000 + ", hostIpAddress=" + this.o00000 + ", prefixLength=" + this.\u00d200000 + ", additionalHostIpSubnets=" + java.lang.String.valueOf(this.\u00d300000) + ", dhcpConfiguration=" + java.lang.String.valueOf(this.String) + ")";
        }
    }
}

