// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists distribution tenants by the customization that you specify.
//
// You must specify either the CertificateArn parameter or WebACLArn parameter,
// but not both in the same request.
func (c *Client) ListDistributionTenantsByCustomization(ctx context.Context, params *ListDistributionTenantsByCustomizationInput, optFns ...func(*Options)) (*ListDistributionTenantsByCustomizationOutput, error) {
	if params == nil {
		params = &ListDistributionTenantsByCustomizationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDistributionTenantsByCustomization", params, optFns, c.addOperationListDistributionTenantsByCustomizationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDistributionTenantsByCustomizationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDistributionTenantsByCustomizationInput struct {

	// Filter by the ARN of the associated ACM certificate.
	CertificateArn *string

	// The marker for the next set of results.
	Marker *string

	// The maximum number of distribution tenants to return by the specified
	// customization.
	MaxItems *int32

	// Filter by the ARN of the associated WAF web ACL.
	WebACLArn *string

	noSmithyDocumentSerde
}

type ListDistributionTenantsByCustomizationOutput struct {

	// A list of distribution tenants with the specified customization.
	DistributionTenantList []types.DistributionTenantSummary

	// A token used for pagination of results returned in the response. You can use
	// the token from the previous request to define where the current request should
	// begin.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDistributionTenantsByCustomizationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListDistributionTenantsByCustomization{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListDistributionTenantsByCustomization{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDistributionTenantsByCustomization"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDistributionTenantsByCustomization(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDistributionTenantsByCustomizationPaginatorOptions is the paginator options
// for ListDistributionTenantsByCustomization
type ListDistributionTenantsByCustomizationPaginatorOptions struct {
	// The maximum number of distribution tenants to return by the specified
	// customization.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDistributionTenantsByCustomizationPaginator is a paginator for
// ListDistributionTenantsByCustomization
type ListDistributionTenantsByCustomizationPaginator struct {
	options   ListDistributionTenantsByCustomizationPaginatorOptions
	client    ListDistributionTenantsByCustomizationAPIClient
	params    *ListDistributionTenantsByCustomizationInput
	nextToken *string
	firstPage bool
}

// NewListDistributionTenantsByCustomizationPaginator returns a new
// ListDistributionTenantsByCustomizationPaginator
func NewListDistributionTenantsByCustomizationPaginator(client ListDistributionTenantsByCustomizationAPIClient, params *ListDistributionTenantsByCustomizationInput, optFns ...func(*ListDistributionTenantsByCustomizationPaginatorOptions)) *ListDistributionTenantsByCustomizationPaginator {
	if params == nil {
		params = &ListDistributionTenantsByCustomizationInput{}
	}

	options := ListDistributionTenantsByCustomizationPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDistributionTenantsByCustomizationPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDistributionTenantsByCustomizationPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDistributionTenantsByCustomization page.
func (p *ListDistributionTenantsByCustomizationPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDistributionTenantsByCustomizationOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDistributionTenantsByCustomization(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDistributionTenantsByCustomizationAPIClient is a client that implements the
// ListDistributionTenantsByCustomization operation.
type ListDistributionTenantsByCustomizationAPIClient interface {
	ListDistributionTenantsByCustomization(context.Context, *ListDistributionTenantsByCustomizationInput, ...func(*Options)) (*ListDistributionTenantsByCustomizationOutput, error)
}

var _ ListDistributionTenantsByCustomizationAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDistributionTenantsByCustomization(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDistributionTenantsByCustomization",
	}
}
