/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration;

import com.google.common.eventbus.Subscribe;
import com.ubnt.service.orchestration.OrchestratorMetadataService;
import com.ubnt.service.orchestration.dto.OrchestrationRemoveDataDto;
import com.ubnt.service.orchestration.dto.OrchestrationRemoveDto;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.mapper.OrchestrationDtoMapper;
import com.ubnt.service.orchestration.model.OrchestratorMetadata;
import com.ubnt.service.orchestration.template.TemplateRemoveHandler;
import com.ubnt.service.orchestration.template.TemplateType;
import com.ubnt.service.orchestration.validator.OrchestrationRemoveEventValidator;
import com.ubnt.service.system.event.F;
import com.ubnt.service.system.jA;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@F
public class OrchestrationRemoveListener {
    private static final Logger LOGGER = jA.ifnew;
    private final OrchestrationRemoveEventValidator orchestrationRemoveEventValidator;
    private final Map<TemplateType, TemplateRemoveHandler> templateRemovalTypeHandlers;
    private final OrchestrationDtoMapper orchestrationDtoMapper;
    private final OrchestratorMetadataService orchestratorMetaDataService;

    @Subscribe
    void \u00d300000(OrchestrationRemoveDto orchestrationRemoveDto) {
        LOGGER.info("[{}] received orchestration-remove event with data: '{}'", (Object)orchestrationRemoveDto.eventType(), (Object)orchestrationRemoveDto.data());
        OrchestrationRemoveDataDto orchestrationRemoveDataDto = orchestrationRemoveDto.data();
        List<IssueDetailReportDto> list = this.orchestrationRemoveEventValidator.getValidationErrors(orchestrationRemoveDataDto, this.templateRemovalTypeHandlers.keySet());
        if (list.isEmpty()) {
            this.\u00d400000(orchestrationRemoveDataDto);
        } else {
            LOGGER.warn("Received invalid orchestration-remove event with validation errors: {}", list);
        }
    }

    private void \u00d400000(OrchestrationRemoveDataDto orchestrationRemoveDataDto) {
        List<String> list = orchestrationRemoveDataDto.siteIds();
        OrchestratorMetadata orchestratorMetadata = this.orchestrationDtoMapper.toOrchestrationMetaData(orchestrationRemoveDataDto).orchestratorMetadata();
        if (orchestratorMetadata == null) {
            LOGGER.warn("Orchestrator metadata is null, proceeding without it.");
        }
        this.orchestratorMetaDataService.handleOrchestrationWithOrchestratorData(this::return, list, orchestrationRemoveDataDto, orchestratorMetadata);
    }

    private void return(List<String> list, OrchestrationRemoveDataDto orchestrationRemoveDataDto) {
        list.forEach(string -> this.o00000((String)string, orchestrationRemoveDataDto));
    }

    private void o00000(String string, OrchestrationRemoveDataDto orchestrationRemoveDataDto) {
        orchestrationRemoveDataDto.templates().forEach(templateMetaDataDto -> this.templateRemovalTypeHandlers.get((Object)templateMetaDataDto.type()).remove(string, orchestrationRemoveDataDto.orchestrationId()));
    }

    @ConstructorProperties(value={"orchestrationRemoveEventValidator", "templateRemovalTypeHandlers", "orchestrationDtoMapper", "orchestratorMetaDataService"})
    @Generated
    public OrchestrationRemoveListener(OrchestrationRemoveEventValidator orchestrationRemoveEventValidator, Map<TemplateType, TemplateRemoveHandler> map, OrchestrationDtoMapper orchestrationDtoMapper, OrchestratorMetadataService orchestratorMetadataService) {
        this.orchestrationRemoveEventValidator = orchestrationRemoveEventValidator;
        this.templateRemovalTypeHandlers = map;
        this.orchestrationDtoMapper = orchestrationDtoMapper;
        this.orchestratorMetaDataService = orchestratorMetadataService;
    }
}

