/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration;

import com.google.common.eventbus.Subscribe;
import com.ubnt.service.orchestration.OrchestrationApplyHandler;
import com.ubnt.service.orchestration.OrchestrationService;
import com.ubnt.service.orchestration.dto.OrchestrationApplyDataDto;
import com.ubnt.service.orchestration.dto.OrchestrationApplyDto;
import com.ubnt.service.orchestration.dto.TemplateMetaDataDto;
import com.ubnt.service.orchestration.dto.fetch.OrchestrationTemplatesFetchResponseDto;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.dto.report.OrchestrationReportDto;
import com.ubnt.service.orchestration.dto.report.OrchestrationSiteReportDto;
import com.ubnt.service.orchestration.dto.report.TemplateReportDto;
import com.ubnt.service.orchestration.exception.OrchestrationFetchDataException;
import com.ubnt.service.orchestration.mapper.OrchestrationDtoMapper;
import com.ubnt.service.orchestration.model.Orchestration;
import com.ubnt.service.orchestration.validator.OrchestrationApplyEventValidator;
import com.ubnt.service.system.event.F;
import com.ubnt.service.system.jA;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@F
public class OrchestrationApplyListener {
    private static final Logger LOGGER = jA.ifnew;
    private final OrchestrationService orchestrationService;
    private final OrchestrationApplyEventValidator orchestrationApplyEventValidator;
    private final OrchestrationDtoMapper orchestrationDtoMapper;
    private final OrchestrationApplyHandler orchestrationApplyHandler;

    @Subscribe
    void \u00d300000(OrchestrationApplyDto orchestrationApplyDto) {
        LOGGER.debug("[{}] received orchestration-apply event with data: '{}'", (Object)orchestrationApplyDto.eventType(), (Object)orchestrationApplyDto.data());
        OrchestrationApplyDataDto orchestrationApplyDataDto = orchestrationApplyDto.data();
        List<IssueDetailReportDto> list = this.orchestrationApplyEventValidator.getValidationErrors(orchestrationApplyDataDto, this.orchestrationApplyHandler.getTypeHandlers());
        if (list.isEmpty()) {
            try {
                OrchestrationTemplatesFetchResponseDto orchestrationTemplatesFetchResponseDto = this.orchestrationService.getOrchestration(orchestrationApplyDataDto);
                this.\u00d200000(orchestrationTemplatesFetchResponseDto, orchestrationApplyDataDto);
            }
            catch (OrchestrationFetchDataException orchestrationFetchDataException) {
                this.\u00d600000(List.of(IssueDetailReportDto.builder().code(orchestrationFetchDataException.getOrchestrationFetchDataError()).issueDetail(orchestrationFetchDataException.getMessage()).build()), orchestrationApplyDataDto);
            }
        } else {
            LOGGER.warn("Received invalid orchestration-apply event. Validation errors: {}", list);
            this.\u00d600000(list, orchestrationApplyDataDto);
        }
    }

    private void \u00d200000(OrchestrationTemplatesFetchResponseDto orchestrationTemplatesFetchResponseDto, OrchestrationApplyDataDto orchestrationApplyDataDto) {
        Orchestration orchestration = this.orchestrationDtoMapper.toOrchestrationModel(orchestrationTemplatesFetchResponseDto, orchestrationApplyDataDto);
        this.null(orchestration, orchestrationApplyDataDto);
    }

    private void null(Orchestration orchestration, OrchestrationApplyDataDto orchestrationApplyDataDto) {
        List<OrchestrationSiteReportDto> list = this.orchestrationApplyHandler.handleOrchestration(orchestration);
        OrchestrationReportDto orchestrationReportDto = OrchestrationReportDto.builder().sites(list).build();
        this.orchestrationService.report(orchestrationApplyDataDto, orchestrationReportDto);
    }

    private void \u00d600000(List<IssueDetailReportDto> list, OrchestrationApplyDataDto orchestrationApplyDataDto) {
        List<OrchestrationSiteReportDto> list2 = this.String(orchestrationApplyDataDto, list);
        this.orchestrationService.report(orchestrationApplyDataDto, OrchestrationReportDto.builder().sites(list2).build());
    }

    private List<OrchestrationSiteReportDto> String(OrchestrationApplyDataDto orchestrationApplyDataDto, List<IssueDetailReportDto> list) {
        return orchestrationApplyDataDto.siteIds().stream().map(string -> OrchestrationSiteReportDto.builder().id((String)string).reports(orchestrationApplyDataDto.templates().stream().findFirst().map(templateMetaDataDto -> this.o00000((TemplateMetaDataDto)templateMetaDataDto, list)).map(List::of).orElse(List.of())).build()).toList();
    }

    private TemplateReportDto o00000(TemplateMetaDataDto templateMetaDataDto, List<IssueDetailReportDto> list) {
        return TemplateReportDto.builder().templateId(templateMetaDataDto.id()).revisionId(templateMetaDataDto.revisionId()).application("network").type(templateMetaDataDto.type()).warnings(List.of()).errors(list).build();
    }

    @ConstructorProperties(value={"orchestrationService", "orchestrationApplyEventValidator", "orchestrationDtoMapper", "orchestrationApplyHandler"})
    @Generated
    public OrchestrationApplyListener(OrchestrationService orchestrationService, OrchestrationApplyEventValidator orchestrationApplyEventValidator, OrchestrationDtoMapper orchestrationDtoMapper, OrchestrationApplyHandler orchestrationApplyHandler) {
        this.orchestrationService = orchestrationService;
        this.orchestrationApplyEventValidator = orchestrationApplyEventValidator;
        this.orchestrationDtoMapper = orchestrationDtoMapper;
        this.orchestrationApplyHandler = orchestrationApplyHandler;
    }
}

