/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.switchacl;

import com.ubnt.data.Device;
import com.ubnt.data.Setting;
import com.ubnt.data.Site;
import com.ubnt.model.api.switchacl.AclEntryCount;
import com.ubnt.model.api.switchacl.AclRuleDto;
import com.ubnt.model.api.switchacl.BatchAclRuleUpdatePartDto;
import com.ubnt.model.api.switchacl.CombinedAclRuleOriginType;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.devmgr.c;
import com.ubnt.service.setting.M.OoOO;
import com.ubnt.service.switchacl.A.float;
import com.ubnt.service.switchacl.A.oo0O;
import com.ubnt.service.switchacl.AclRuleDocument;
import com.ubnt.service.switchacl.D;
import com.ubnt.service.switchacl.O;
import com.ubnt.service.switchacl.O00OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.ubnt.service.switchacl.Stringsuper;
import com.ubnt.service.system.setting.H;
import com.ubnt.service.system.setting.Oo0O;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Switch ACL Rules")
public class AclRuleController {
    private final O super;
    private final O00OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO \u00d200000;
    private final Stringsuper \u00d300000;
    private final c \u00d600000;
    private final OoOO \u00d400000;
    private final Oo0O class;

    @GetMapping(value={"/api/site/{siteName}/{mac}/acl-entry-count"})
    @Operation(summary="ACL Entry Count")
    public AclEntryCount getAclEntryCount(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string) {
        String string2 = site.getId();
        if (!this.\u00d600000.nullprivatereturn(string2, string, Device::supportsSwitchAccessControlList)) {
            return AclEntryCount.empty();
        }
        Setting setting = this.class.\u00d300000(H.\u00f8o0000, string2);
        int n2 = this.\u00d400000.Object(string2, setting);
        int n3 = this.\u00d300000.\u00d500000(string2, string);
        return AclEntryCount.builder().globalAclEntryCount(n2).customIpAclEntryCount(n3).customMacAclEntryCount(0).build();
    }

    @GetMapping(value={"/api/site/{siteName}/acl-rules"})
    @Operation(summary="List ACL Rules")
    public List<AclRuleDto> listAclRules(@PathVariable(value="siteName") Site site) {
        Stream<AclRuleDto> stream = this.\u00d400000(site);
        Stream<AclRuleDto> stream2 = this.new(site);
        return Stream.concat(stream, stream2).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/acl-rules"}, consumes={"application/json"})
    @Operation(summary="Create a new ACL Rule")
    @ResponseStatus(value=HttpStatus.CREATED)
    public AclRuleDto createAclRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull AclRuleDto aclRuleDto) {
        AclRuleDocument aclRuleDocument;
        try {
            aclRuleDocument = this.super.null(aclRuleDto.toDocument(site.getId()));
        }
        catch (float float_) {
            throw oo0O.\u00d800000(float_);
        }
        return AclRuleDto.fromDocument(aclRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/acl-rules/{ruleId}"}, consumes={"application/json"})
    @Operation(summary="Update ACL Rule")
    public AclRuleDto updateAclRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string, @RequestBody @Valid @NotNull AclRuleDto aclRuleDto) {
        AclRuleDocument aclRuleDocument;
        AclRuleDto aclRuleDto2 = AclRuleDto.withId(aclRuleDto, string);
        try {
            aclRuleDocument = this.super.o00000(aclRuleDto2.toDocument(site.getId()));
        }
        catch (float float_) {
            throw oo0O.\u00d800000(float_);
        }
        return AclRuleDto.fromDocument(aclRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/acl-rules"}, consumes={"application/json"})
    @Operation(summary="Update Selected Properties of ACL Rules in Batch")
    public List<AclRuleDto> batchUpdateAclRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<BatchAclRuleUpdatePartDto> list) {
        List<D> list2 = list.stream().map(BatchAclRuleUpdatePartDto::toBatchUpdatePart).toList();
        return this.super.\u00d800000(site.getId(), list2).stream().map(AclRuleDto::fromDocument).toList();
    }

    @DeleteMapping(value={"/api/site/{siteName}/acl-rules/{ruleId}"})
    @Operation(summary="Delete ACL Rule")
    public void deleteAclRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string) {
        this.super.\u00d500000(site.getId(), string);
    }

    @PostMapping(value={"/api/site/{siteName}/acl-rules/batch-delete"}, consumes={"application/json"})
    @Operation(summary="Delete ACL Rules in Batch")
    public void deleteAclRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<String> list) {
        this.super.String(site.getId(), list);
    }

    private Stream<AclRuleDto> new(Site site) {
        return this.\u00d200000.\u00d400000(site.getId()).stream().map(aclRuleDocument -> AclRuleDto.builderFromDocument(aclRuleDocument).predefined(true).originType(CombinedAclRuleOriginType.OBJECT_ACL_RULE).originId(this.o00000(aclRuleDocument.getId())).build());
    }

    private String o00000(String string) {
        String[] stringArray = string.split("_");
        if (stringArray.length != 3) {
            return "";
        }
        return stringArray[1];
    }

    private Stream<AclRuleDto> \u00d400000(Site site) {
        return this.super.\u00d600000(site.getId()).stream().map(AclRuleDto::fromDocument);
    }

    @ConstructorProperties(value={"aclRuleService", "derivedAclRuleService", "customSwitchAclCounter", "deviceManager", "globalSwitchAclCounter", "settingService"})
    @Generated
    public AclRuleController(O o2, O00OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO o00OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2, Stringsuper stringsuper, c c2, OoOO ooOO2, Oo0O oo0O2) {
        this.super = o2;
        this.\u00d200000 = o00OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2;
        this.\u00d300000 = stringsuper;
        this.\u00d600000 = c2;
        this.\u00d400000 = ooOO2;
        this.class = oo0O2;
    }
}

