/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.bgp;

import com.ubnt.data.Site;
import com.ubnt.model.api.bgp.BgpRouterDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.bgp.BgpRouterDocument;
import com.ubnt.service.bgp.D;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@V2RestController
@Tag(name="BGP")
@Validated
public class BgpController {
    private final D o00000;

    public BgpController(D d2) {
        this.o00000 = d2;
    }

    @GetMapping(value={"/api/site/{siteName}/bgp/config"})
    public List<BgpRouterDto> getGatewayBgpConfig(@PathVariable(value="siteName") Site site) {
        return this.o00000.class(site.getId()).stream().map(BgpRouterDto::ofDocument).toList();
    }

    @GetMapping(value={"/api/site/{siteName}/bgp/config/all"})
    public List<BgpRouterDto> getAllBgpConfigs(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d4O0000(site.getId()).stream().map(BgpRouterDto::ofDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/bgp/config"})
    @Operation(summary="Upload Gateway BGP config")
    public BgpRouterDto createOrUpdateGatewayBgpConfig(@PathVariable(value="siteName") Site site, @RequestBody @Valid BgpRouterDto bgpRouterDto) {
        BgpRouterDocument bgpRouterDocument = bgpRouterDto.toDocument(site.getId());
        return BgpRouterDto.ofDocument(this.o00000.do(site.getId(), bgpRouterDocument));
    }

    @PostMapping(value={"/api/site/{siteName}/bgp/config/{deviceMac}"})
    @Operation(summary="Upload Device BGP config")
    public BgpRouterDto createOrUpdateDeviceBgpConfig(@PathVariable(value="siteName") Site site, @PathVariable(value="deviceMac") String string, @RequestBody @Valid BgpRouterDto bgpRouterDto) {
        BgpRouterDocument bgpRouterDocument = bgpRouterDto.toDocument(site.getId(), string);
        return BgpRouterDto.ofDocument(this.o00000.do(site.getId(), bgpRouterDocument));
    }

    @DeleteMapping(value={"/api/site/{siteName}/bgp/config"})
    @Operation(summary="Delete Gateway BGP config")
    public void deleteGatewayBgpConfig(@PathVariable(value="siteName") Site site) {
        this.o00000.\u00d2O0000(site.getId());
    }

    @DeleteMapping(value={"/api/site/{siteName}/bgp/config/{deviceMac}"})
    @Operation(summary="Delete Device BGP config")
    public void deleteDeviceBgpConfig(@PathVariable(value="siteName") Site site, @PathVariable(value="deviceMac") String string) {
        this.o00000.\u00d6O0000(site.getId(), string);
    }
}

